% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnm.R
\name{logd}
\alias{logd}
\title{Log-density and its derivative values}
\usage{
logd(x, beta, pt, which)
}
\arguments{
\item{x}{an object of a class for data.}

\item{beta}{instrumental parameter in a semiparametric mixture.}

\item{pt}{a vector of values for the mixing variable theta.}

\item{which}{an integer vector of length 3, indicating if,
respectively, the log-density values, the derivatives wrt beta
and the derivatives wrt theta are to be computed and returned if
being 1 (\code{TRUE}).}
}
\value{
\item{ld}{a matrix, storing the log-density values for each (x[i],
beta, pt[j], or NULL if not asked for.}

\item{db}{a matrix, storing the log-density derivatives wrt beta
for each (x[i], beta, pt[j], or NULL if not asked for.}

\item{dt}{a matrix, storing the log-density derivatives wrt theta
for each (x[i], beta, pt[j], or NULL if not asked for.}
}
\description{
A generic method to compute the log-density values
  and possibly their first derivatives with respec to theta and
  beta.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
