% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpt_importance.R
\name{cpt_importance}
\alias{cpt_importance}
\title{Change-point importance (prominence) plot}
\usage{
cpt_importance(nsp.obj)
}
\arguments{
\item{nsp.obj}{Object returned by one of the \code{nsp*} functions.}
}
\value{
The function does not return a value.
}
\description{
This function produces a change-point prominence plot based on the NSP object provided. The heights of the bars are arranged in non-decreasing
order and correspond directly to the lengths of the NSP intervals of significance. Each bar is labelled as s-e where s (e) is the start (end) of the
corresponding NSP interval of significance, respectively. The change-points corresponding to the narrower intervals can be seen as more prominent.
}
\details{
The NSP algorithm is described in P. Fryzlewicz (2021) "Narrowest Significance Pursuit: inference for multiple change-points in linear
models", preprint.
}
\examples{
set.seed(1)
f <- c(rep(0, 100), 1:100, rep(101, 100))
x.f <- f + 15 * stats::rnorm(300)
x.f.n <- nsp_poly(x.f, 100, "sim", deg=1)
cpt_importance(x.f.n)
}
\seealso{
\code{\link{draw_rects}}, \code{\link{draw_rects_advanced}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
