% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trle_cond_stat.R
\name{trle_cond_stat}
\alias{trle_cond_stat}
\title{Statistics of events in a sequence}
\usage{
trle_cond_stat(x, b, b_op, stat)
}
\arguments{
\item{x}{numeric vector.}

\item{b}{integer. Value threshold.}

\item{b_op}{character. Operator, \code{gte} = greater than or equal, \code{lte} = less than or equal, \code{gt} = greater than, \code{lt} = less than, \code{e} = equal.}

\item{stat}{character. A statistic to be calculated. One of: max, min, mean, median, sd, var.}
}
\value{
a numeric value
}
\description{
This function will compute statistics of sequential events that meets some conditions.
}
\details{
Example: in a vector, what is the maximum size of sequences with values equal or greater than 5?
}
\examples{
# What is the maximum size of sequences with values equal or greater than 5?
trle_cond_stat(c(4,6,6,4,7,8,9), b = 5, b_op = "gte", stat = "max")

}
