% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R
\docType{package}
\name{nse}
\alias{nse}
\alias{nse-package}
\title{nse: Computation of numerical standard errors in R}
\description{
\code{nse} (Ardia and Bluteau, 2017) is an \R package for computing the numerical standard error (NSE), an estimate
of the standard deviation of a simulation result, if the simulation experiment were to be repeated
many times. The package provides a set of wrappers around several R packages, which give access to
more than thirty NSE estimators, including batch means
estimators (Geyer, 1992, Section 3.2), initial sequence estimators Geyer (1992, Equation 3.3),
spectrum at zero estimators (Heidelberger and Welch, 1981), heteroskedasticity
and autocorrelation consistent (HAC) kernel estimators (Newey and West, 1987; Andrews, 1991; Andrews and
Monahan, 1992; Newey and West, 1994; Hirukawa, 2010), and bootstrap estimators Politis and
Romano (1992, 1994); Politis and White (2004). The full set of estimators is described in
Ardia et al. (2018).
}
\note{
Functions rely on the packages \code{coda}, \code{mcmc},\code{mcmcse}, \code{np}, and \code{sandwich}.

Please cite the package in publications. Use \code{citation("nse")}.
}
\section{Functions}{

\itemize{
\item \code{\link{nse.geyer}}: Geyer NSE estimator.
\item \code{\link{nse.spec0}}: Spectral density at zero NSE estimator.
\item \code{\link{nse.nw}}: Newey-West NSE estimator.
\item \code{\link{nse.andrews}}: Andrews NSE estimator.
\item \code{\link{nse.hiruk}}: Hirukawa NSE estimator.
\item \code{\link{nse.boot}}: Bootstrap NSE estimator.
}
}

\references{
Andrews, D.W.K. (1991).
Heteroskedasticity and autocorrelation consistent covariance matrix estimation.
\emph{Econometrica} \bold{59}(3),  817-858.

Andrews, D.W.K, Monahan, J.C. (1992).
An improved heteroskedasticity and autocorrelation consistent covariance matrix estimator.
\emph{Econometrica} \bold{60}(4),  953-966.

Ardia, D., Bluteau, K., Hoogerheide, L. (2018).
Methods for computing numerical standard errors: Review and application to Value-at-Risk estimation.
\emph{Journal of Time Series Econometrics} \bold{10}(2), 1-9.
\doi{10.1515/jtse-2017-0011}
\doi{10.2139/ssrn.2741587}

Ardia, D., Bluteau, K. (2017).
nse: Computation of numerical standard errors in R.
\emph{Journal of Open Source Software} \bold{10}(2).
\doi{10.21105/joss.00172}

Geyer, C.J. (1992).
Practical Markov chain Monte Carlo.
\emph{Statistical Science} \bold{7}(4),  473-483.

Heidelberger, P., Welch, Peter D. (1981).
A spectral method for confidence interval generation and run length control in simulations.
\emph{Communications of the ACM} \bold{24}(4),  233-245.

Hirukawa, M. (2010).
A two-stage plug-in bandwidth selection and its implementation for covariance estimation.
\emph{Econometric Theory} \bold{26}(3),  710-743.

Newey, W.K., West, K.D. (1987).
A simple, positive semi-definite, heteroskedasticity and autocorrelationconsistent covariance matrix.
\emph{Econometrica} \bold{55}(3),  703-708.

Newey, W.K., West, K.D. (1994) .
Automatic lag selection in covariance matrix estimation.
\emph{Review of Economic Studies} \bold{61}(4), 631-653.

Politis, D.N., Romano, and J.P. (1992).
A circular block-resampling procedure for stationary data.
In \emph{Exploring the limits of bootstrap}, John Wiley & Sons, 263-270.

Politis, D.N., Romano, and J.P. (1994).
The stationary bootstrap.
\emph{Journal of the American Statistical Association} \bold{89}(428), 1303-1313.

Politis, D.N., White, H. (2004).
Automatic block-length selection for the dependent bootstrap.
\emph{Econometric Reviews} \bold{23}(1), 53-70.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/keblu/nse}
  \item Report bugs at \url{https://github.com/keblu/nse/issues}
}

}
\author{
David Ardia and Keven Bluteau
}
