% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cardinality.R
\name{colCardinalities}
\alias{colCardinalities}
\title{Cardinality of Column Vectors}
\usage{
colCardinalities(w)
}
\arguments{
\item{w}{a numeric matrix, e.g. \code{xcoef} as returned by \code{\link{nscancor}}}
}
\value{
A vector containing the number of non-zero elements of each column of \code{w}
}
\description{
Computes the cardinality (the number of non-zero elements) of each column of
the matrix \eqn{\mathbf{w}}{w}.
}
\examples{
# returns c(2, 1)
colCardinalities(matrix(c(1, 0, 2, -1, 0, 0), ncol = 2))


}
