% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp.R
\name{as.sp}
\alias{as.sp}
\alias{as.sp.grid.par}
\alias{as.sp.data.grid}
\title{Convert npsp object to sp object}
\usage{
as.sp(obj, ...)

\method{as.sp}{grid.par}(obj, ...)

\method{as.sp}{data.grid}(obj, data.ind = NULL, proj4string = CRS(as.character(NA)), ...)
}
\arguments{
\item{obj}{a \code{\link{npsp}} object.}

\item{...}{further arguments passed to or from other methods.}

\item{data.ind}{integer or character; vector with indexes or names of the data components.}

\item{proj4string}{a \code{\link[sp]{CRS-class}} object.}
}
\value{
\code{as.sp.grid.par} returns a \code{\link[sp]{GridTopology-class}} object.

\code{as.sp.data.grid} returns a \code{\link[sp]{SpatialGridDataFrame-class}} object.
}
\description{
Converts a npsp object to a \link[sp:00sp]{sp} object.
}
\seealso{
\code{\link{as.data.frame.data.grid}}
}
