% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_arrange.R
\name{nest_arrange}
\alias{nest_arrange}
\title{Arrange rows within a nested data frames by column values}
\usage{
nest_arrange(.data, .nest_data, ..., .by_group = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{Variables, or functions of variables. Use \code{\link[dplyr:desc]{dplyr::desc()}} to sort
a variable in descending order.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will be also of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item All rows appear in the output, but (usually) in a different place.
\item Columns are not modified.
\item Groups are not modified.
\item Data frame attributes are preserved.
}
}
\description{
\code{nest_arrange()} orders the rows of nested data frames by the values of
selected columns.
}
\details{
\code{nest_arrange()} is largely a wrapper for \code{\link[dplyr:arrange]{dplyr::arrange()}} and maintains
the functionality of \code{arrange()} within each nested data frame. For more
information on \code{arrange()}, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% 
  nest_arrange(country_data, pop)

gm_nest \%>\%
  nest_arrange(country_data, desc(pop))
}
\seealso{
Other single table verbs: 
\code{\link{nest_filter}()},
\code{\link{nest_mutate}()},
\code{\link{nest_rename}()},
\code{\link{nest_select}()},
\code{\link{nest_slice}()},
\code{\link{nest_summarise}()}
}
\concept{single table verbs}
