% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_join.R
\name{nest-mutate-joins}
\alias{nest-mutate-joins}
\alias{nest_inner_join}
\alias{nest_left_join}
\alias{nest_right_join}
\alias{nest_full_join}
\title{Nested Mutating joins}
\usage{
nest_inner_join(
  .data,
  .nest_data,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = FALSE
)

nest_left_join(
  .data,
  .nest_data,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = FALSE
)

nest_right_join(
  .data,
  .nest_data,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = FALSE
)

nest_full_join(
  .data,
  .nest_data,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = FALSE
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{y}{A data frame, data frame extension (e.g., a tibble), or a lazy data
frame (e.g., from dbplyr or dtplyr).}

\item{by}{A character vector of variables to join by or a join specification
created with \code{join_by()}.

If \code{NULL}, the default, \verb{nest_*_join()} will perform a natural join, using
all variables in common across each object in \code{.nest_data} and \code{y}. A
message lists the variables so you can check they're correct; suppress the
message by supplying \code{by} explicitly.

To join on different variables between the objects in \code{.nest_data} and \code{y},
use a named vector. For example, \code{by = c("a" = "b")} will match
\code{.nest_data$a} to \code{y$b} for each object in \code{.nest_data}.

To join by multiple variables, use a vector with length >1. For example,
\code{by = c("a", "b")} will match \code{.nest_data$a} to \code{y$a} and \code{.nest_data$b} to
\code{y$b} for each object in \code{.nest_data}. Use a named vector to match
different variables in \code{.nest_data} and \code{y}. For example,
\code{by = c("a" = "b", "c" = "d")} will match \code{.nest_data$a} to \code{y$b} and
\code{.nest_data$c} to \code{y$d} for each object in \code{.nest_data}.

To perform a cross-join, generating all combinations of each object in
\code{.nest_data} and \code{y}, use \code{by = character()}.}

\item{copy}{If \code{.nest_data} and \code{y} are not from the same data source and
\code{copy = TRUE} then \code{y} will be copied into the same src as \code{.nest_data}.
\emph{(Need to review this parameter in more detail for applicability with nplyr)}}

\item{suffix}{If there are non-joined duplicate variables in \code{.nest_data} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{...}{Other parameters passed onto methods. Includes:
\itemize{
\item \code{na_matches} : Should two \code{NA} or two \code{NaN} values match?
\itemize{
\item \code{"na"}, the default, treats two \code{NA} or two \code{NaN} values as equal.
\item \code{"never"} treats two \code{NA} or two \code{NaN} values as different, and will
never match them together or to any other values.
}
\item \code{multiple} : Handling of rows in \code{.nest_data} with multiple matches in \code{y}.
\itemize{
\item \code{"all"} returns every match detected in \code{y}.
\item \code{"any"} returns one match detected in \code{y}, with no guarantees on which
match will be returned. It is often faster than \code{"first"} and \code{"last"} if
you just need to detect if there is at least one match.
\item \code{"first"} returns the first match detected in \code{y}.
\item \code{"last"} returns the last match detected in \code{y}.
\item \code{"warning"} throws a warning if multiple matches are detected, and then
falls back to \code{"all"}.
\item \code{"error"} throws an error if multiple matches are detected.
}
\item \code{unmatched} : How should unmatched keys that would result in dropped rows
be handled?
\itemize{
\item \code{"drop"} drops unmatched keys from the result.
\item \code{"error"} throws an error if unmatched keys are detected.
}
}}

\item{keep}{Should the join keys from both \code{.nest_data} and \code{y} be preserved
in the output?}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. The order of the rows and columns
of each object in \code{.nest_data} is preserved as much as possible. Each object
in \code{.nest_data} has the following properties:
\itemize{
\item For \code{nest_inner_join()}, a subset of rows in each object in \code{.nest_data}.
For \code{nest_left_join()}, all rows in each object in \code{.nest_data}.
For \code{nest_right_join()}, a subset of rows in each object in \code{.nest_data},
followed by unmatched \code{y} rows.
For \code{nest_full_join()}, all rows in each object in \code{.nest_data}, followed
by unmatched \code{y} rows.
\item Output columns include all columns from each \code{.nest_data} and all non-key
columns from \code{y}. If \code{keep = TRUE}, the key columns from \code{y} are included
as well.
\item If non-key columns in any object in \code{.nest_data} and \code{y} have the same name,
\code{suffix}es are added to disambiguate. If \code{keep = TRUE} and key columns in
\code{.nest_data} and \code{y} have the same name, \code{suffix}es are added to
disambiguate these as well.
\item If \code{keep = FALSE}, output columns included in \code{by} are coerced to their
common type between the objects in \code{.nest_data} and \code{y}.
\item Groups are taken from \code{.nest_data}.
}
}
\description{
Nested mutating joins add columns from \code{y} to each of the nested data frames
in \code{.nest_data}, matching observations based on the keys. There are four
nested mutating joins:
\subsection{Inner join}{

\code{nest_inner_join()} only keeps observations from \code{.nest_data} that have a
matching key in \code{y}.

The most important property of an inner join is that unmatched rows in either
input are not included in the result.
}

\subsection{Outer joins}{

There are three outer joins that keep observations that appear in at least
one of the data frames:
\itemize{
\item \code{nest_left_join()} keeps all observations in \code{.nest_data}.
\item \code{nest_right_join()} keeps all observations in \code{y}.
\item \code{nest_full_join()} keeps all observations in \code{.nest_data} and \code{y}.
}
}
}
\details{
\code{nest_inner_join()}, \code{nest_left_join()}, \code{nest_right_join()}, and
\code{nest_full_join()} are largely wrappers for \code{\link[dplyr:mutate-joins]{dplyr::inner_join()}},
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}}, \code{\link[dplyr:mutate-joins]{dplyr::right_join()}}, and \code{\link[dplyr:mutate-joins]{dplyr::full_join()}} and
maintain the functionality of these verbs within each nested data frame. For
more information on \code{inner_join()}, \code{left_join()}, \code{right_join()}, or
\code{full_join()}, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)
gm_codes <- gapminder::country_codes

gm_nest \%>\% nest_inner_join(country_data, gm_codes, by = "country")
gm_nest \%>\% nest_left_join(country_data, gm_codes, by = "country")
gm_nest \%>\% nest_right_join(country_data, gm_codes, by = "country")
gm_nest \%>\% nest_full_join(country_data, gm_codes, by = "country")

}
\seealso{
Other joins: 
\code{\link{nest-filter-joins}},
\code{\link{nest_nest_join}()}
}
\concept{joins}
