% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npi_results_s3.R
\name{npi_summarize}
\alias{npi_summarize}
\title{S3 method to summarize an \code{npi_results} object}
\usage{
npi_summarize(object, ...)
}
\arguments{
\item{object}{An \code{npi_results} S3 object}

\item{...}{Additional optional arguments}
}
\value{
Tibble containing the following columns:
  \describe{
    \item{\code{npi}}{National Provider Identifier (NPI) number}
    \item{\code{name}}{Provider's first and last name for individual
    providers, organization name for organizational providers.}
    \item{\code{enumeration_type}}{Type of provider associated with the NPI,
      either "Individual" or "Organizational"}
    \item{\code{primary_practice_address}}{Full address of the provider's
      primary practice location}
    \item{\code{phone}}{Provider's telephone number}
    \item{\code{primary_taxonomy}}{Primary taxonomy description}
  }
}
\description{
S3 method to summarize an \code{npi_results} object
}
\examples{
data(npis)
npi_summarize(npis)
}
\concept{summary functions}
