% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simultane_Inferenz_Funktionen_nph_1-3.R
\name{nphparams}
\alias{nphparams}
\title{Simultaneous Inference For Parameters Quantifying Differences Between Two Survival Functions}
\usage{
nphparams(
  time,
  event,
  group,
  data = parent.frame(),
  param_type,
  param_par = NA,
  param_alternative = NA,
  lvl = 0.95,
  closed_test = FALSE,
  alternative_test = "two.sided",
  alternative_CI = "two.sided",
  haz_method = "local",
  rhs = 0,
  perturb = FALSE,
  Kpert = 500
)
}
\arguments{
\item{time}{vector of observed event/censored times.}

\item{event}{Vector with entries 0 or 1 (or FALSE/TRUE) indicating if an event was observed (1) or the time is censored (0).}

\item{group}{group indicator, must be a vector with entries 0 or 1 indicating the allocation of a subject to one of two groups.
Group 0 is regarded as reference group when calculating parameters.}

\item{data}{an optional data frame containing the time, event and group data.}

\item{param_type}{character vector defining the set of parameters that should be analysed. Possible entries are "S","logS","cloglogS",
"Q","logQ","RMST","avgHR","score" and "HR", representing differences in survival probabilities, log survival probabilities,
complementary log log (cloglog) transformed survival probabilities, quantiles of the survival functions,
log transformed quantiles, restricted mean survival times, as well as an average hazard ratio, the Cox model score statistic (logrank statistic),
and the Cox-model hazard ratio.}

\item{param_par}{numeric vector which contains the time points at which the requested parameters are evaluated (e.g. x-year survival or RMST after x-years),
or, in case of analysing quantiles, the according probability. May be \code{NA} for parameter types "RMST","avgHR","score" or "HR". In this case,
the minimum of the largest event times of the two groups is used. Also, times greater than this minimum are replaced by this minumum for "RMST","avgHR","score" or "HR".}

\item{param_alternative}{optional character vector with entries "less" or "greater", defining the alternative for each parameter.
Only required if one-sided tests or one-sided confidence intervals are requested.
Note that group 0 is regarded as reference group when calculating parameters and therefore whether "greater" or "less" corresponds
to a benefit may depend on the type of parameter. In general, to show
larger survival in group 1 compared to group 0, alternatives would be "greater" for parameter types "S", "logS", "Q", "logQ" and "RMST"
and would be "less" for parameters types "cloglogS",
"avgHR","HR", and "score".
(The score test is defined here such that alternative "less" corresponds to smaller hazard (and better survival) in group 1 compared to group 0.)}

\item{lvl}{Confidence level. Applies to, both, unadjusted and multiplicity adjusted (simultaneous) confidence intervals.}

\item{closed_test}{logical indicating whether p-values should be adjusted using a closed testing procedure. Default is \code{FALSE}, and in this case
p-values will be adjusted by a single step procedure.
With \eqn{k} hypotheses this involves the computation of \eqn{2^k} tests, which may require considerable computation time.}

\item{alternative_test}{character with possible values "tow.sided" (default) or "one-sided". Specifies whether hypothesis tests should be two-sided or one-sided. In the #'    latter case, \code{param_alternative} must be defined.}

\item{alternative_CI}{character with possible values "tow.sided" (default) or "one-sided". Specifies whether confidence intervals should be two-sided or one-sided.
In the latter case, \code{param_alternative} must be defined.}

\item{haz_method}{character with possible values "local" or "muhaz". Specifies whether local hazard should be calculated under a local constant hazard assumption (default) #'    or using the function \code{\link[muhaz]{muhaz}} from the muhaz package. Only relevant when median or log(median) survival
times are analysed.}

\item{rhs}{right-hand side vector of null hypotheses. Refers to log-scaled difference for ratios. Default is to consider for all null hypothesis a difference of 0.}

\item{perturb}{logical, indicating whether the perturbation based estiamte should be used instead of the asymptotic estimate to calculate the covariance matrix.
Defaults to \code{FALSE}.}

\item{Kpert}{The number of perturbation samples to be used with the perturbation approach for covariance estimation.}
}
\value{
A list of class \code{nphparams} with elements:
\describe{
\item{\code{est}}{Estimated differences (at log-scale in case of ratios).}
\item{\code{V}}{Estimated covariance matrix of differences.}
\item{\code{tab}}{A data frame with analysis results. Contains the parameter type (Parameter) and settings (Time_or_which_quantile), the estimated difference (Estimate),
its standard error (SE), unadjusted confidence interval lower and upper bounds (lwr_unadjusted, upr_unadjusted), unadjusted p-values (p_unadj),
mulitplicity adjusted confidence interval lower and upper bounds (lwr_adjusted, upr_adjusted), single-step multiplcity adjusted p-values (p_adj),
closed-test adjusted p-values, if requested (p_adjusted_closed_test) and for comparison Bonferroni-Holm adjusted p-values (p_Holm).}
\item{\code{param}}{The used parameter settings. If \code{param_par} was \code{NA} for "HR","avgHR" or "RMST", it is replaced by \code{minmaxt} here.}
\item{\code{paramin}}{The parameter settings as provided to the function. The only difference to \code{param} is in \code{param_par}, as \code{NA} is not replaced here.}
\item{\code{dat0}}{A data frame with information on all observed events in group 0. Contains time (t), number of events (ev), Nelson-Aalen estimate (NAsurv)
and Kaplan-Meier estimate (KMsurv) of survival, and the number at risk (atrisk).}
\item{\code{dat1}}{A data frame with information on all observed events in group 1. Contains time (t), number of events (ev), Nelson-Aalen estimate (NAsurv)
and Kaplan-Meier estimate (KMsurv) of survival, and the number at risk (atrisk).}
\item{\code{minmaxt}}{Minimum of the largest event times of the two groups.}
\item{\code{est0}}{Estimated parameter values in group 0.}
\item{\code{est1}}{Estimated parameter values in group 1.}
\item{\code{V0}}{Estimated covariance matrix of parameter estimates in group 0.}
\item{\code{V1}}{Estimated covariance matrix of parameter estimates in group 1.}
}
}
\description{
Hypothesis tests with parametric multiple testing adjustment and simultaneous confidence intervals
for a set of parameters, which quantify differences between two survival functions. Eligible parameters are differences in survival probabilities, log survival probabilities,
complementary log log (cloglog) transformed survival probabilities, quantiles of the survival functions,
log transformed quantiles, restricted mean survival times, as well as an average hazard ratio, the Cox model score statistic
(logrank statistic), and the Cox-model hazard ratio.
}
\examples{
data(pembro)
set1<-nphparams(time=time, event=event, group=group,data=pembro,
param_type=c("score","S"),
param_par=c(3.5,2),
param_alternative=c("less","greater"),
closed_test=TRUE,alternative_test="one.sided")
print(set1)
plot(set1,trt_name="Pembrolizumab",ctr_name="Cetuximab")

set2<-nphparams(time=time, event=event, group=group, data=pembro,  
param_type=c("S","S","S","Q","RMST"),
param_par=c(0.5,1,2,0.5,3.5))
print(set2)
plot(set2,showlines=TRUE,show_rmst_diff=TRUE)

#Create a summary table for set2, showing parameter estimates for each group and the
#estimated differences between groups. Also show unadjusted and multiplicity adjusted
#confidence intervals using the multivariate normal method and, for comparison,
#Bonferroni adjusted confidence intervals:

set2Bonf<-nphparams(time=time, event=event, group=group, data=pembro,  
param_type=c("S","S","S","Q","RMST"),
param_par=c(0.5,1,2,0.5,3.5),
lvl=1-0.05/5)
KI_paste<-function(x,r) {
x<-round(x,r)
paste("[",x[,1],", ",x[,2],"]",sep="")
}
r<-3
tab<-data.frame(
Parameter=paste(set2$tab[,1],set2$tab[,2]),
Pembrolizumab=round(set2$est1,r),
Cetuximab=round(set2$est0,r),
Difference=round(set2$tab$Estimate,r),
CI_undadj=KI_paste(set2$tab[,5:6],r),
CI_adj=KI_paste(set2$tab[,8:9],r),
CI_Bonf=KI_paste(set2Bonf$tab[,c(5:6)],r))
tab

}
\seealso{
\code{\link{print.nphparams}}, \code{\link{plot.nphparams}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
