% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_weights.R
\name{find_weights}
\alias{find_weights}
\title{Calculate weights}
\usage{
find_weights(
  formula,
  data,
  method,
  t_star = NULL,
  s_star = NULL,
  rho = NULL,
  gamma = NULL,
  include_cens = FALSE,
  timefix = TRUE
)
}
\arguments{
\item{formula}{Formula object. The response (on the left of the \code{~} operator) must be a survival object as returned by the \code{Surv} function.
The terms (on the right of the \code{~} operator) must include the treatment arm indicator, and additionally can include strata using the \code{strata} function.}

\item{data}{Data frame containing time-to-event data.}

\item{method}{Character string specifying type of weighted log-rank test.
Either \code{"lr"} for a standard log-rank test, \code{"mw"} for a modestly-weighted log-rank test,
or \code{"fh"} for the Fleming-Harrington rho-gamma family.}

\item{t_star}{Parameter \eqn{t^*} in the modestly weighted (\code{"mw"}) test, see Details.}

\item{s_star}{Parameter \eqn{s^*} in the modestly weighted (\code{"mw"}) test, see Details.}

\item{rho}{Parameter \eqn{\rho} in the Fleming-Harrington (\code{"fh"}) test, see Details.}

\item{gamma}{Parameter \eqn{\gamma} in the Fleming-Harrington (\code{"fh"}) test, see Details.}

\item{include_cens}{Boolean indicating whether to include values corresponding to censoring times}

\item{timefix}{Deal with floating point issues (as in the survival package). Default is TRUE. May need to set FALSE for simulated data.}
}
\value{
Vector of weights in the weighted log-rank test.
The weights correspond to the ordered, distinct event times (and censoring times if
\code{include_cens=TRUE}).
}
\description{
This function can perform two types of weighted log-rank test,
the modestly-weighted log-rank test and the Fleming-Harrington (\eqn{\rho},\eqn{\gamma}) test, in addition to the standard log-rank test.
}
\details{
Select which of the three tests to perform using argument \code{method}.
The output is calculated as outlined in \code{vignette("weighted_log_rank_tests", package="nphRCT")}.
}
\examples{
library(nphRCT)
set.seed(1)
sim_data <- sim_events_delay(
  event_model=list(
    duration_c = 36,
    duration_e = c(6,30),
    lambda_c = log(2)/9,
    lambda_e = c(log(2)/9,log(2)/18)
  ),
  recruitment_model=list(
    rec_model="power",
    rec_period = 12,
    rec_power = 1
  ),
  n_c=5,
  n_e=5,
  max_cal_t = 36
)
#example setting t_star
find_weights(formula=Surv(event_time,event_status)~group,
  data=sim_data,
  method="mw",
  t_star = 4
)
}
\references{
Magirr, D. (2021).
Non-proportional hazards in immuno-oncology: Is an old perspective needed?.
Pharmaceutical Statistics, 20(3), 512-527.
\url{doi:10.1002/pst.2091}

Magirr, D. and Burman, C.F., 2019.
Modestly weighted logrank tests.
Statistics in medicine, 38(20), 3782-3790.
}
