% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-pwr2n.LR.R
\name{pwr2n.LR}
\alias{pwr2n.LR}
\alias{phsize}
\title{Sample Size Calculation under Proportional Hazards}
\usage{
pwr2n.LR(
  method = c("schoenfeld", "freedman"),
  lambda0,
  lambda1,
  ratio = 1,
  entry = 0,
  fup,
  alpha = 0.05,
  beta = 0.1,
  alternative = c("two.sided"),
  Lparam = NULL,
  summary = TRUE
)
}
\arguments{
\item{method}{calculation formula, Default: c("schoenfeld", "freedman")}

\item{lambda0}{hazard rate for the control group}

\item{lambda1}{hazard rate for the treatment group}

\item{ratio}{randomization ratio between treatment and control. For example,
ratio=2 if randomization ratio is 2:1 to treatment and control group.
Default:1}

\item{entry}{enrollment time. A constant enrollment rate is assumed,
Default: 0}

\item{fup}{follow-up time.}

\item{alpha}{type I error rate, Default: 0.05}

\item{beta}{type II error rate. For example,if the target power is 80\%, beta is 0.2.
Default: 0.1}

\item{alternative}{a value must be one of ("two.sided", "one.sided"), indicating
whether a two-sided or one-sided test to use.  Default: c("two.sided")}

\item{Lparam}{a vector of shape and scale parameters for the drop-out Weibull distribution,
See Details below. Default: NULL}

\item{summary}{a logical controlling whether a brief summary is printed or not
, Default: TRUE}
}
\value{
a list of components including
\item{eventN}{a numeric value giving the total number of events}
\item{totalN}{a numeric value giving the total number of subjects}
\item{summary}{a list containing the input parameters and output results}
}
\description{
\code{pwr2n.LR} calculates the total number of events and total
number of subjects required given the provided design parameters based on either
schoenfeld or freedman formula.
}
\details{
Both Schoenfeld's formula and Freedman's formula are included in the
function \code{pwr2n.LR}.
The total event number is determined by \eqn{\alpha, \beta} and
hazard ratio, i.e., \eqn{\lambda_1/\lambda_0}. Other design parameters such as
enrollment period affects the event probability and thus the total sample size.
A fixed duration design is assumed in the calculation. All patients are enrolled
at a constant rate within \code{entry} time and have at least \code{fup}
time of follow-up. So the total study duration is \code{entry}+\code{fup}.
If drop-out is expected, a Weibull distribution with shape parameter -\eqn{\alpha}
and scale parameter - \eqn{\beta} is considered. The CDF of Weibull is
\eqn{F(x)=1-exp(-(x/\beta)^\alpha)}, where \eqn{\alpha} is the shape
parameter and \eqn{\beta} is the scale parameter. The event rate
is calculated through numeric integration. See more details in
\code{\link{cal_event}}.
}
\examples{
# define design parameters
l0 <- log(2)/14; HR <- 0.8; RR <- 2; entry <- 12; fup <- 12;
eg1 <- pwr2n.LR( method    = c("schoenfeld")
                 ,l0
                 ,l0*HR
                 ,ratio=RR
                 ,entry
                 ,fup
                 ,alpha     = 0.05
                 ,beta      = 0.1
)
# event number, total subjects, event probability
c(eg1$eventN,eg1$totalN,eg1$eventN/eg1$totalN)

# example 2: drop-out from an exponential with median time is 30
eg2 <- pwr2n.LR( method    = c("schoenfeld")
                 ,l0
                 ,l0*HR
                 ,ratio=RR
                 ,entry
                 ,fup
                 ,alpha     = 0.05
                 ,beta      = 0.1
                 ,Lparam = c(1,30/log(2))
)
# event number, total subjects, event probability
c(eg2$eventN,eg2$totalN,eg2$eventN/eg2$totalN)
}
\references{
Schoenfeld, D. (1981) The asymptotic properties of nonparametric
tests for comparing survival distributions. Biometrika, 68,
316–319.

Freedman, L. S. (1982) Tables of the number of patients required
in clinical trials using the logrank test. Statistics in medicine, 1, 121–129.
}
\seealso{
\code{\link{pwr2n.NPH}},
\code{\link{evalfup}}, \code{\link{cal_event}}
}
