% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-MaxLRtest.R
\name{MaxLRtest}
\alias{MaxLRtest}
\title{Maximum Weighted Logrank Test}
\usage{
MaxLRtest(
  dat,
  Wlist,
  base = c("KM"),
  alpha = 0.05,
  alternative = c("two.sided")
)
}
\arguments{
\item{dat}{a dataframe or matrix. The first three columns of the data
set are survival
time, event status indicator  and group label. The status indicator, normally
0=alive, 1=dead/event. Other choices are TRUE/FALSE (TRUE=death) or 1/2 (2=death).
The group label can be either numeric values like 0=control, 1=treatment or text
like C=control, T=treatment.}

\item{Wlist}{a list with components of weight functions}

\item{base}{a text must be one of c("\code{KM}", "\code{Combined}", "\code{N}"),
Default: c("KM")}

\item{alpha}{a number indicating type I error rate, Default: 0.05}

\item{alternative}{a text must be one of c("\code{two.sided}", "\code{less}",
\code{"greater"}), indicating the alternative hypothesis, Default: c("two.sided")}
}
\value{
a list of components including
\item{stat}{a numeric value indicating the test statistic. It is logrank or weighted logrank test
statistic if one weight function is specified. Otherwise, it gives
the maximum weighted logrank test statistic, which takes the maximum
of absolute values of all the statistics. }
\item{stat.mat}{a matrix with the first column showing weighted
logrank test statistics and other columns displaying the variance and
covariance between statistics}
\item{critV}{a numeric value indicating the critical value corresponding to the nominal
level - \code{alpha}}
\item{details}{a dataframe showing the intermediate variables used in the
calculation. }
\item{p.value}{a numeric value indicating the p-value of the test}
}
\description{
\code{MaxLRtest} performs the maximum weighted logrank test if
multiple weight functions are provided. It is the regular weighted logrank test,
if a single weight function is specified,
}
\details{
\code{MaxLRtest} function performs logrank, weighted logrank test such as
Fleming-Harrington test and maximum weighted logrank test depending on
the type and number of weight functions. Let \eqn{w(x_t)} denote the weight applied
at event time point \eqn{t}, where \eqn{x_t} is the base function. There are three options
for \code{base}. If \code{KM} is used, \eqn{x_t=1-S_t}, where \eqn{S_t}
is pooled Kaplan-Meier estimate of survival rate at time point t. A FH(1,0) test
needs a weight function \eqn{1-x_t}. If \code{Combined} base is selected,
\eqn{x_t=1-S^*_t}, where \eqn{S^*_t=w_1S^1_t+w_0S^0_t}, the weighted average
of KM estimate of survival rate for treatment (\eqn{S^1_t}) and control group
(\eqn{S^0_t}). It is considered more robust in case of unbalanced data.
For option \code{N}, \eqn{x_t=1-\frac{Y_t}{N}}, where \eqn{Y_t} is the subjects
at risk at time t and \eqn{N} is the total number of subjects.The Wilcoxon and
tarone test should use this base. The base \eqn{x_t} in all three cases is an
increasing function of time t. Function \code{gen.wgt} helps to generate the commonly
used weight functions.

Let \eqn{\Lambda_1} and \eqn{\Lambda_0} denote the cumulative hazard for
treatment and control group. The alternative of a two-sided test is
\eqn{H_a: \Lambda_1 \neq \Lambda_0}. The \code{"less"} alternative
corresponds to \eqn{H_a: \Lambda_1 < \Lambda_0} and the \code{"greater"}
alternative is \eqn{H_a: \Lambda_1 > \Lambda_0}.

A p-value is obtained from a multivariate normal distribution if multiple weights
are provided. The function \code{pmvnorm} from R package \pkg{mvtnorm} is used.
Because the algorithm is slightly seed-dependent,the p-value and critical value
is the average of 10 runs.
}
\examples{
data(lung)
#Only keep variables for analysis
tmpd <- with(lung, data.frame(time=SurvTime,stat=1-censor,grp=Treatment))
#logrank test
wlr <- gen.wgt(method = "LR")
t1 <- MaxLRtest(tmpd, Wlist = wlr, base = c("KM") )
t1$stat ;t1$p.value


# maxcombo test
wmax <- gen.wgt(method="Maxcombo")
t2 <- MaxLRtest(tmpd, Wlist = wmax, base = c("KM") )
t2$stat ;t2$p.value
#visualize the weight functions
plot(t2)
}
\seealso{
\code{\link{pwr2n.NPH}}, \code{\link{gen.wgt}}
}
