% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NpdeData.R
\docType{class}
\name{NpdeData-class}
\alias{NpdeData-class}
\alias{NpdeData}
\alias{print,NpdeData-method}
\alias{summary,NpdeData-method}
\alias{npde.qqplot,NpdeData-method}
\title{Class "NpdeData" representing the structure of the longitudinal data}
\description{
A longitudinal data structure
}
\section{Objects from the Class}{
 NpdeData objects are typically created by a call to \code{\link{npdeData}} contain the following slots:

\describe{
\item{name.group}{character string giving the name of the grouping term (ID)}
\item{name.predictor}{character string giving the name of the predictor (X)}
\item{name.response}{character string giving the name of the response (Y)}
\item{name.cens}{character string giving the name of the censoring indicator in the original dataset (renamed to cens)}
\item{name.mdv}{character string giving the name of the missing data indicator in the original dataset (renamed to mdv)}
\item{name.covariates}{vector of character string giving the name(s) of the covariates}
\item{name.ipred}{character string giving the name of the individual predictions}
\item{units}{(optional) a list with the units for X, Y, and covariates}
\item{data}{a dataframe containing the data}
\item{N}{number of subjects}
\item{ntot.obs}{total number of non-missing observations}
\item{nind.obs}{vector of size N giving the number of non-missing observations for each subject}
\item{ind}{index of non-missing observations}
\item{icens}{index of censored observations (non-missing)}
\item{not.miss}{a vector of boolean indicating for each observation whether it is missing (FALSE) or available (TRUE)}
\item{loq}{the censoring value}
}
}

\section{Methods}{

\describe{
  \item{show(npde.data):}{Prints a short summary of object npde.data}
  \item{qqplot.npde(npde.data):}{QQ-plot for NpdeData object (TODO: change for NpdeObject in final package)}
}
}

\examples{
methods(class="NpdeData")
showClass("NpdeData")
}
\keyword{classes}
