context("matching_Python_results")
library(nos)

test_that("Main functions match python output", {

  ##These are data and results generated by
  #Giovanni from the python package

  #load in example data
  data("testList")
  y <- testList[[1]][[1]] #unipartite data
  pot_net <- testList[[1]][[2]] #unipartite_potential data
  y2 <- testList[[1]][[3]]#bipartite data


  #create matrix to save test results
  df2 <- matrix(NA, nrow = 5, ncol = 8)
  colnames(df2) <- c("nes_in", "nes_out", "nes",
                    "mod_in",
                    "mod_out","mod","z", "p")

  #Test all functinos
  x <- NOSM_POT_dir(y, pot_net, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[1,] <- as.vector(s1)

  x <- NOSM_POT_undir(y, pot_net, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[2,c(3,6:8)] <- as.vector(s1)

  x <- NOSM_dir(y, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[3,] <- as.vector(s1)

  x <- NOSM_undir(y, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[4,c(3,6:8)] <- as.vector(s1)

  x <- NOSM_bip(y2, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[5,] <- as.vector(s1)

  df2 <- as.data.frame(round(df2, 3))

  df2 <- cbind(as.data.frame(c("potential_directed",
                             "potential_undirected",
                            "directed",
                            "undirected","bipartite")), df2)

  colnames(df2)[1] <- "network"

  #Check results match up
  expect_true(identical(df2, testList[[1]][[4]]))
})



test_that("Main functions match python output: take 2", {

  ##These are data and results generated by
  #Giovanni from the python package

  #load in example data
  data("testList")
  y <- testList[[2]][[1]] #unipartite data
  pot_net <- testList[[2]][[2]] #unipartite_potential data
  y2 <- testList[[2]][[3]]#bipartite data


  #create matrix to save test results
  df2 <- matrix(NA, nrow = 5, ncol = 8)
  colnames(df2) <- c("nes_in", "nes_out", "nes",
                     "mod_in",
                     "mod_out","mod","z", "p")

  #Test all functinos
  x <- NOSM_POT_dir(y, pot_net, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[1,] <- as.vector(s1)

  x <- NOSM_POT_undir(y, pot_net, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[2,c(3,6:8)] <- as.vector(s1)

  x <- NOSM_dir(y, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[3,] <- as.vector(s1)

  x <- NOSM_undir(y, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[4,c(3,6:8)] <- as.vector(s1)

  x <- NOSM_bip(y2, perc = 1, sl = 1)
  s1 <- summary(x)
  df2[5,] <- as.vector(s1)

  df2 <- as.data.frame(round(df2, 3))

  df2 <- cbind(as.data.frame(c("potential_directed",
                               "potential_undirected",
                               "directed",
                               "undirected","bipartite")), df2)

  colnames(df2)[1] <- "network"

  #Check results match up
  expect_true(identical(df2, testList[[2]][[4]]))
})

test_that("Other stuff works", {

  expect_error(NOSM_POT_dir("y", pot_net, perc = 1,
                            sl = 1))

  expect_error(NOSM_POT_dir(y, "pot_net", perc = 1,
                            sl = 1))

  expect_error(NOSM_POT_dir(y, perc = 1, sl = 1))

  data(boreal)
  y <-  boreal[1:300,] #subset 300 rows for speed
  d <- sample(nrow(y), 200, replace = FALSE) #create a random pot_net
  pot_net <- y[d,] #by randomly sampling 200 rows from boreal
  x <- NOSM_POT_dir(y, pot_net, perc = 1, sl = 1)

  expect_s3_class(x, "NOSM")
  expect_true(attributes(x)$Type == "Pot_dir")

  x2 <- summary(x)
  expect_s3_class(x2, "summary.NOSM")

  y$V1[5] <- NA
  expect_error(NOSM_POT_dir(y, pot_net, perc = 1, sl = 1))

})
