% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superset.R
\name{ignored}
\alias{ignored}
\title{Extract Index for Ignored Records}
\usage{
ignored(
  x,
  read.input = list(read.csv, header = TRUE, as.is = TRUE),
  ext = getOption("modex", "ctl"),
  project = getOption("project", getwd()),
  nested = getOption("nested", TRUE),
  ...
)
}
\arguments{
\item{x}{length-one character: a model name}

\item{read.input}{list of arguments representing a methodology for acquiring the data of interest: the first argument is not named and will be passed to match.fun(); the other arguments will be passed to the result, and must include an argument named 'header'.}

\item{ext}{model file extension, e.g. 'mod' or 'ctl'}

\item{project}{project directory (can be expression)}

\item{nested}{whether model files are nested in eponymous directories}

\item{...}{passed to \code{\link{modelfile}} and \code{link{datafile}}}
}
\value{
logical
}
\description{
Extracts index for ignored records, given a NONMEM control stream.
}
\seealso{
Other superset: 
\code{\link{generalize}()},
\code{\link{meta}()},
\code{\link{meta.character}()},
\code{\link{meta.numeric}()},
\code{\link{metaplot.character}()},
\code{\link{metaplot.numeric}()},
\code{\link{metaplot_character}()},
\code{\link{metasuperset}()},
\code{\link{ninput}()},
\code{\link{ninput.character}()},
\code{\link{ninput.numeric}()},
\code{\link{shuffle}()},
\code{\link{superset}()},
\code{\link{superset.character}()},
\code{\link{superset.numeric}()},
\code{\link{superspec}()},
\code{\link{superspec.character}()},
\code{\link{superspec.numeric}()}
}
\concept{superset}
