% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothing-rules.R
\name{smooth_dec}
\alias{smooth_dec}
\title{Decreasing first-order smoothing rule}
\usage{
smooth_dec(x, xt, b, qu)
}
\arguments{
\item{x}{\code{numeric} value of the last value of the parameter.}

\item{xt}{\code{numeric} vector of past values of the parameter (time series).}

\item{b}{smoothing parameter \eqn{b}.}

\item{qu}{smoothing parameter \eqn{q}.}
}
\value{
A \code{numeric} vector of updated parameters.
}
\description{
Decreasing smoothing rule
\deqn{x_{t+1}:=a_t\,x_t + (1-a_t)\,x_{t-1}}
where
\deqn{a_t:= b\,\left(1-\left(1-\frac{1}{t}\right)^q\right)}
for some \eqn{0.7\leq b\leq1} and some \eqn{5\leq q\leq10}.
}
\seealso{
Other smoothing rules: 
\code{\link{smooth_lin}()}
}
\concept{smoothing rules}
