% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/027_pai_bdir_ln.R
\name{pai_bdir_ln}
\alias{pai_bdir_ln}
\alias{pai_bdir_ln.default}
\alias{pai_bdir_ln.formula}
\title{Pairwise bidirectional label noise}
\usage{
\method{pai_bdir_ln}{default}(x, y, level, pairs, order = levels(y), sortid = TRUE, ...)

\method{pai_bdir_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{pairs}{a list of integer vectors with the indices of classes to corrupt.}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Pairwise bidirectional label noise} into a classification dataset.
}
\details{
For each vector (\emph{c1}, \emph{c2}) in \code{pairs}, 
\emph{Pairwise bidirectional label noise} randomly selects (\code{level}·100)\% of the samples
from class \emph{c1} in the dataset and (\code{level}·100)\% of the samples from class
\emph{c2}. Then, \emph{c1} samples are mislabeled as belonging to \emph{c2} and 
\emph{c2} samples are mislabeled as belonging to \emph{c1}. The order of the class labels is 
determined by \code{order}.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# create new class with some samples
class <- as.character(iris2D$Species)
class[iris2D$Petal.Length > 6] <- "newclass"
iris2D$Species <- as.factor(class)

# usage of the default method
set.seed(9)
outdef <- pai_bdir_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                      level = 0.1, pairs = list(c(1,2), c(3,4)), 
                      order = c("virginica", "setosa", "newclass", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- pai_bdir_ln(formula = Species ~ ., data = iris2D, 
                      level = 0.1, pairs = list(c(1,2), c(3,4)), 
                      order = c("virginica", "setosa", "newclass", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
S. Fefilatyev, M. Shreve, K. Kramer, L. O. Hall, D. B. Goldgof, R. Kasturi, K. Daly, A. Remsen, and H. Bunke. 
\strong{Label-noise reduction with support vector machines}. 
In \emph{Proc. 21st International Conference on Pattern Recognition}, pages 3504-3508, 2012.
url:\url{https://ieeexplore.ieee.org/document/6460920/}.
}
\seealso{
\code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
