% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/026_opes_idu_ln.R
\name{opes_idu_ln}
\alias{opes_idu_ln}
\alias{opes_idu_ln.default}
\alias{opes_idu_ln.formula}
\title{Open-set ID/uniform label noise}
\usage{
\method{opes_idu_ln}{default}(x, y, level, openset = c(1), order = levels(y), sortid = TRUE, ...)

\method{opes_idu_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double with the noise level in [0,1] to be introduced.}

\item{openset}{an integer vector with the indices of classes in the open set (default: \code{c(1)}).}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Open-set ID/uniform label noise} into a classification dataset.
}
\details{
\emph{Open-set ID/uniform label noise} corrupts (\code{level}·100)\% of the samples with classes in \code{openset}. 
For each sample selected, a label from in-distribution classes is randomly chosen. The order of the class 
labels for the indices in \code{openset} is determined by \code{order}.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- opes_idu_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                     level = 0.4, order = c("virginica", "setosa", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- opes_idu_ln(formula = Species ~ ., data = iris2D, 
                     level = 0.4, order = c("virginica", "setosa", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
P. H. Seo, G. Kim, and B. Han. \strong{Combinatorial inference against label noise}. 
In \emph{Advances in Neural Information Processing Systems}, volume 32, pages 1171-1181, 2019.
url:\url{https://proceedings.neurips.cc/paper/2019/hash/0cb929eae7a499e50248a3a78f7acfc7-Abstract.html}.
}
\seealso{
\code{\link{asy_spa_ln}}, \code{\link{mind_bdir_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
