% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stationid.R
\name{get_stationid}
\alias{get_stationid}
\title{Retrieve Station IDs for a Given Dataset and Location}
\usage{
get_stationid(
  noaa_token,
  datasetid,
  locationid = NULL,
  startdate,
  enddate,
  n_results = Inf
)
}
\arguments{
\item{noaa_token}{A character string. Your NOAA API token used for authentication. You can request a token at https://www.ncdc.noaa.gov/cdo-web/token.}

\item{datasetid}{A valid dataset ID (e.g., "GHCND", "GSOM", etc.). Use \code{valid_ids()} to see supported values.}

\item{locationid}{Optional. A valid location ID (e.g., "FIPS:37", "CITY:US390029"). If \code{NULL}, all locations are considered.}

\item{startdate}{Start date (YYYY-MM-DD) for station data coverage.}

\item{enddate}{End date (YYYY-MM-DD) for station data coverage.}

\item{n_results}{Maximum number of station results to retrieve. Defaults to \code{Inf} to fetch all available.}
}
\value{
A data frame containing metadata for the matching NOAA stations.
}
\description{
Queries the NOAA Climate Data Online (CDO) API to retrieve station identifiers
associated with a specified dataset, location, and date range.
}
\examples{
if (nzchar(Sys.getenv("NOAA_TOKEN"))) {
  # Retrieve your NOAA API token from environment
  noaa_token <- Sys.getenv("NOAA_TOKEN")

  # Get stations for the GHCND dataset in Texas between 2020-01-01 and 2020-12-31
  stations <- get_stationid(
    noaa_token = noaa_token,
    datasetid = "GHCND",
    locationid = "FIPS:48",
    startdate = "2020-01-01",
    enddate = "2020-12-31"
  )
  head(stations)
}

}
