% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-functions_processing.R
\name{nmr_import_peaks}
\alias{nmr_import_peaks}
\title{Import and process picked peaks data}
\usage{
nmr_import_peaks(path, method, pattern = "*.csv$", quiet = FALSE)
}
\arguments{
\item{path}{Directory where the peaks data are saved}

\item{method}{Format of input data, depending on how the data were exported.
"multiple columns": data are in split-column format, obtained by
pasting "peaks table" in MNova. "single column": data are in
single-column format, exported from MNova as "peaks script".}

\item{pattern}{Filename pattern to search for (by default "*.csv$")}

\item{quiet}{Print diagnostic messages? Logical}
}
\value{
A dataframe with columns describing
  sample ID, ppm, intensity, area, group name.
}
\description{
Process data of peaks picked with NMR software.
}
\examples{
sdir <- system.file("extdata", "kfp_hysteresis", "peaks_mnova_multiple", package = "nmrrr")
nmr_import_peaks(path = sdir, method = "multiple columns")
}
\author{
Kaizad Patel
}
