% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bins_ss_Baldock2004}
\alias{bins_ss_Baldock2004}
\title{NMR grouping bins from Baldock et al. (2004).}
\format{
A data frame with 5 rows and 5 variables:
\describe{
  \item{number}{Bin number}
  \item{group}{Name of bin group}
  \item{start}{ppm shift range, lower limit}
  \item{stop}{ppm shift range, upper limit}
  \item{description}{Description of the bin group}
}
}
\source{
J. Baldock et al. "Cycling and composition of organic matter in terrestrial and marine ecosystems". Marine Chemistry.
\doi{10.1016/j.marchem.2004.06.016}
}
\usage{
bins_ss_Baldock2004
}
\description{
NMR grouping bins from  Baldock et al. (2004), for solid-state NMR.
(1) alkyl C (0-45);
(2) methoxyl C and N-alkyl C (45-60);
(3) O-alkyl C (60-95);
(4) di-O-alkyl C (95-110);
(5) aromatic C (110-145);
(6) phenolic C (145-165);
(7) amide and carboxyl C (165-215)
}
\note{
The NMR spectrum can be split into several bins, based on
chemical shift (ppm). Binsets are specific to nuclei and solvents and
by definition are open on the left and closed on the right;
for example, a bin of (0,1) includes 1 but \emph{not} 0.
}
\seealso{
\code{\link{bins_Clemente2012}} \code{\link{bins_Lynch2019}}
\code{\link{bins_Mitchell2018}}
}
\keyword{datasets}
