% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{confidence_intervals}
\alias{confidence_intervals}
\title{Confidence interval methods for (non)-linear models}
\usage{
confidence_intervals(
  x,
  method = c("wald", "profile", "bootstrap", "simple-bayes", "all"),
  parm,
  level = 0.95,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{object of class \code{\link[stats]{lm}}, \code{\link[stats]{nls}}, \code{\link[nlme]{nlme}}, \code{\link[nlme]{gls}} or \code{\link[nlme]{gnls}}}

\item{method}{method or methods to use. Possible options are: \sQuote{wald}, \sQuote{profile}, \sQuote{bootstrap}, \sQuote{all}}

\item{parm}{optional character string to select the parameter}

\item{level}{probability level}

\item{verbose}{logical (default FALSE) whether to print messages}

\item{...}{additional arguments to be passed to function \code{\link[boot]{boot}}}
}
\description{
Confidence interval methods for (non)-linear models.
Method \sQuote{wald} for objects of class \sQuote{nls} uses
 \code{\link[stats]{confint.default}}
}
\examples{
\donttest{
require(car)
data(barley, package = "nlraa")
## Fit a linear model (quadratic)
fit.lm <- lm(yield ~ NF + I(NF^2), data = barley)

cfs.int <- confidence_intervals(fit.lm, method = c("wald", "bootstrap"))

fit.nls <- nls(yield ~ SSlinp(NF, a, b, xs), data = barley)

cfs.int2 <- confidence_intervals(fit.nls, method = c("wald", "profile", "bootstrap"))

}

}
