% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{profileFixed}
\alias{profileFixed}
\alias{profileFixedSingle}
\title{Estimate the objective function values for a model while fixing defined
parameter values}
\usage{
profileFixed(fitted, which, control = list())

profileFixedSingle(fitted, which)
}
\arguments{
\item{fitted}{The fit model}

\item{which}{A data.frame with column names of parameters to fix and values
of the fitted value to fix (one row only).}

\item{control}{A list passed to \code{fixedControl()} (currently unused)}
}
\value{
\code{which} with a column named \code{OFV} added with the objective function
value of the fitted estimate fixing the parameters in the other columns
}
\description{
Estimate the objective function values for a model while fixing defined
parameter values
}
\section{Functions}{
\itemize{
\item \code{profileFixedSingle()}: Estimate the objective function value for a model
while fixing a single set of defined parameter values (for use in parameter
profiling)

}}
\seealso{
Other Profiling: 
\code{\link{fixedControl}()},
\code{\link{llpControl}()},
\code{\link{profile.nlmixr2FitCore}()},
\code{\link{profileLlp}()},
\code{\link{profileNlmixr2FitCoreRet}()}

Other Profiling: 
\code{\link{fixedControl}()},
\code{\link{llpControl}()},
\code{\link{profile.nlmixr2FitCore}()},
\code{\link{profileLlp}()},
\code{\link{profileNlmixr2FitCoreRet}()}
}
\author{
Bill Denney (changed by Matt Fidler to take out R 4.1 specific code)
}
\concept{Profiling}
