% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NF_utils.R
\name{simNodes}
\alias{simNodes}
\alias{calcNodes}
\alias{getLogProbNodes}
\title{Basic nimbleFunctions for calculate, simulate, and getLogProb with a set of nodes}
\usage{
simNodes(model, nodes)

calcNodes(model, nodes)

getLogProbNodes(model, nodes)
}
\arguments{
\item{model}{A NIMBLE model}

\item{nodes}{A set of nodes. If none are provided, default is all \code{model$getNodeNames()}}
}
\description{
simulate, calculate, or get existing log probabilities for the current values in a NIMBLE model
}
\details{
These are basic nimbleFunctions that take a model and set of nodes and return a function that will call \code{calculate}, \code{simulate}, or \code{getLogProb} on those nodes.  Each is equivalent to a direct call from R, but in nimbleFunction form they can be be compiled.  For example, \code{myCalc <- calcNodes(model, nodes); ans <- myCalc()} is equivalent to \code{ans <- model$calculate(nodes)}, but one can also do \code{CmyCalc <- compileNimble(myCalc)} to get a faster version. Note that this will often be much faster than using `calculate` from R with a compiled model, such as \code{compiled_model$calculate(nodes)} because of overhead in running `calculate` from R.

In nimbleFunctions, one would generally use \code{model$calculate(nodes)} in the run-time code (and similarly for `simulate` and `getLogProb`).
}
\author{
Perry de Valpine
}
