% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHomeRangeArea.R
\name{getHomeRangeArea}
\alias{getHomeRangeArea}
\title{Computation of home range radius and area}
\usage{
getHomeRangeArea(
  x = 2,
  detFun = 0,
  prob = 0.95,
  d = 6,
  xlim = c(0, 30),
  ylim = c(0, 30),
  nBreaks = 800,
  tol = 0.00001,
  nIter = 2000
)
}
\arguments{
\item{x}{\code{Vector} or \code{matrix} (parameters in columns) of values for different parameters corresponding to the specified detection function.}

\item{detFun}{\code{Numeric} vNumeric variable denoting the type of detection function. 0 = Half-normal, 1 = Half-normal plateau, 2 = Exponential, 3 = Asymmetric logistic, 4 = Bimodal, 5 = Donut.}

\item{prob}{\code{Numeric}  variable denoting the quantile probability to compute the home range radius.}

\item{d}{\code{Numeric} variable giving an initial value of the radius.}

\item{xlim}{\code{Vector} of length 2 giving the range along x-axis.}

\item{ylim}{\code{Vector} of length 2 giving the range along y-axis.}

\item{nBreaks}{\code{Numeric} variable denoting the number of breaks along an axis.}

\item{tol}{\code{Numeric} variable denoting the allowed tolerance in the radius estimate.}

\item{nIter}{\code{Numeric} variable giving the maximum number of iterations in bisection algorithm.}
}
\description{
\code{getHomeRangeArea} returns approximates estimates of home range radius and area for a given set of parameters with respect to a specified detection function using bisection algorithm. The following circular detection functions are available to use in nimbleSCR: half-normal (detFun = 0), half-normal plateau (detFun = 1), exponential (detFun = 2), asymmetric logistic (detFun = 3), bimodal (detFun = 4) and donut (detFun = 5).
}
\examples{

\dontrun{

# A user friendly vignette is also available on github: 
# https://github.com/nimble-dev/nimbleSCR/blob/master/nimbleSCR/vignettes/
# Vignette name: Fit_with_dbinomLocal_normalPlateau_and_HomeRangeAreaComputation.rmd

# HALF-NORMAL PLATEAU FUNCTION (detFun = 1) 
habitatMask <- matrix(1, nrow = 30, ncol= 30, byrow = TRUE)

prob <- 0.95
paramnames.hr <- c("HRradius", "HRarea")
sigma <- 1
w <- 1.5
params <- c(sigma, w)
names(params) <- c("sigma", "w")
HRAnim <- getHomeRangeArea( x = params, detFun = 1, prob = prob, d = 6,
                      xlim = c(0, dim(habitatMask)[2]), ylim = c(0, dim(habitatMask)[1]),
                      nBreaks = 800, tol = 1E-5, nIter = 2000)

# Different values of argument "detFun"
# 0 = Half-normal, 1 = Half-normal plateau, 2 = Exponential,
# 3 = Aysmmetric logistic, 4 = Bimodal, 5 = Donut.
HR.hnp <- c(HRAnim$run())
names(HR.hnp) <- paramnames.hr
print(HR.hnp)
# FASTER HRA COMPUTATION USING NIMBLE
samples <- cbind(rgamma(n = 500, shape = 1, rate = 1), rgamma(n = 500, shape = 1.5, rate = 1))
colnames(samples) <- c("sigma", "w")
HRAnim.mat <- getHomeRangeArea(x = samples, detFun = 1, prob = prob, d = 6, 
                         xlim = c(0, dim(habitatMask)[2]), ylim = c(0, dim(habitatMask)[1]),
                         nBreaks = 800, tol = 1E-5, nIter = 2000)

cHRAnim.arr <- compileNimble(HRAnim.mat, resetFunctions = TRUE)

HRA.Runtime <- system.time(
  HR.chain <- cHRAnim.arr$run()
)
print(HRA.Runtime)
dimnames(HR.chain)[[2]] <- paramnames.hr
HRest <- do.call(rbind, lapply(c(1:2), function(j){
  c(mean(HR.chain[,j], na.rm = TRUE), sd(HR.chain[,j], na.rm = TRUE))
}))
dimnames(HRest) <- list(paramnames.hr, c("MEAN", "SD"))

cat("Numerical estimates using MCMC samples: \n", sep = "")
print(HRest)

# HALF-NORMAL FUNCTION (detFun = 0) 
sigma = 2
params <- c(sigma)
names(params) <- c("sigma")

HRAnim <- getHomeRangeArea(x = params, detFun = 0, prob = prob, d = 6, 
                     xlim = c(0, dim(habitatMask)[2]), ylim = c(0, dim(habitatMask)[1]),
                     nBreaks = 800, tol = 1E-5, nIter = 2000)

HR.hn <- c(HRAnim$run())
names(HR.hn) <- paramnames.hr
print(HR.hn)

# Exponential (detFun = 2) 

rate = 1/2
params <- c(rate)
names(params) <- c("rate")
HRAnim <- getHomeRangeArea(x = params, detFun = 2, prob = prob, d = 6, 
                     xlim = c(0, dim(habitatMask)[2]), ylim = c(0, dim(habitatMask)[1]),
                     nBreaks = 800, tol = 1E-5, nIter = 2000)
HR.exp <- c(HRAnim$run())
names(HR.exp) <- paramnames.hr
print(HR.exp)

# Asymmetric logistic (detFun = 3) 

sigma = 2
alpha.a = 5 
alpha.b = 1
params <- c(sigma, alpha.a, alpha.b)
names(params) <- c("sigma", "alpha.a", "alpha.b")
HRAnim <- getHomeRangeArea(x = params, detFun = 3, prob = prob, d = 6, 
                     xlim = c(0, dim(habitatMask)[2]), ylim = c(0, dim(habitatMask)[1]),
                     nBreaks = 800, tol = 1E-5, nIter = 2000)
HR.al <- c(HRAnim$run())
names(HR.al) <- paramnames.hr
print(HR.al)


# Bimodal (detFun = 4) 

p0.a = 0.25
sigma.a = 0.5
p0.b = 0.15 
sigma.b = 1
w = 2
params <- c(sigma.a, sigma.b, p0.a, p0.b, w)
names(params) <- c("sigma.a", "sigma.b", "p0.a", "p0.b", "w")
HRAnim <- getHomeRangeArea(x = params, detFun = 4, prob = prob, d = 6, 
                     xlim = c(0, dim(habitatMask)[2]), ylim = c(0, dim(habitatMask)[1]),
                     nBreaks = 800, tol = 1E-5, nIter = 2000)
HR.bi <- c(HRAnim$run())
names(HR.bi) <- paramnames.hr
print(HR.bi)

# Donut (detFun = 5) 

sigma.a = 1.5 
sigma.b = 1 
w = 1 
params <- c(sigma.a, sigma.b, w)
names(params) <- c("sigma.a", "sigma.b", "w")
HRAnim <- getHomeRangeArea(x = params, detFun = 5, prob = prob, d = 6, 
                     xlim = c(0, dim(habitatMask)[2]), ylim = c(0, dim(habitatMask)[1]),
                     nBreaks = 800, tol = 1E-5, nIter = 2000)
HR.dn <- c(HRAnim$run())
names(HR.dn) <- paramnames.hr
print(HR.dn)

}

}
\references{
Dey, S., Bischof, R., Dupont, P. P. A., & Milleret, C. (2022). Does the punishment fit the crime? Consequences and diagnosis of misspecified detection functions in Bayesian spatial capture–recapture modeling. Ecology and Evolution, 12, e8600. https://doi.org/10.1002/ece3.8600
}
\author{
Soumen Dey
}
