% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWindowSizes.R
\name{calcWindowSizes}
\alias{calcWindowSizes}
\title{Window size calculation}
\usage{
calcWindowSizes(lowerCoords, upperCoords)
}
\arguments{
\item{lowerCoords}{Matrix of lower x- and y-coordinates of all windows. One row for each window.}

\item{upperCoords}{Matrix of upper x- and y-coordinates of all windows. One row for each window.}
}
\value{
A vector of window sizes.
}
\description{
Calculates the sizes of a set of windows based on their lower and upper coordinates of each dimension.
Can be applied to detection and habitat windows.
}
\examples{
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 3, 1, 1, 4, 3, 4), nrow = 4, byrow = TRUE)
calcWindowSizes(lowerCoords, upperCoords)


}
\author{
Wei Zhang
}
