% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dNmixtureAD.R
\name{dNmixtureAD}
\alias{dNmixtureAD}
\alias{dNmixtureAD_s}
\alias{dNmixtureAD_v}
\alias{rNmixtureAD_s}
\alias{rNmixtureAD_v}
\alias{dNmixtureAD_BNB_v}
\alias{dNmixtureAD_BNB_s}
\alias{dNmixtureAD_BNB_oneObs}
\alias{dNmixtureAD_BBP_v}
\alias{dNmixtureAD_BBP_s}
\alias{dNmixtureAD_BBP_oneObs}
\alias{dNmixtureAD_BBNB_v}
\alias{dNmixtureAD_BBNB_s}
\alias{rNmixtureAD_BBNB_oneObs}
\alias{rNmixtureAD_BNB_v}
\alias{rNmixtureAD_BNB_s}
\alias{rNmixtureAD_BNB_oneObs}
\alias{rNmixtureAD_BBP_v}
\alias{rNmixtureAD_BBP_s}
\alias{rNmixtureAD_BBP_oneObs}
\alias{rNmixtureAD_BBNB_v}
\alias{rNmixtureAD_BBNB_s}
\alias{dNmixtureAD_BBNB_oneObs}
\title{N-mixture distributions with AD support for use in \code{nimble} models}
\usage{
dNmixtureAD_v(x, lambda, prob, Nmin = -1, Nmax = -1, len, log = 0)

dNmixtureAD_s(x, lambda, prob, Nmin = -1, Nmax = -1, len, log = 0)

rNmixtureAD_v(n, lambda, prob, Nmin, Nmax, len)

rNmixtureAD_s(n, lambda, prob, Nmin, Nmax, len)

dNmixtureAD_BNB_v(x, lambda, theta, prob, Nmin = -1, Nmax = -1, len, log = 0)

dNmixtureAD_BNB_s(x, lambda, theta, prob, Nmin = -1, Nmax = -1, len, log = 0)

dNmixtureAD_BNB_oneObs(x, lambda, theta, prob, Nmin = -1, Nmax = -1, log = 0)

rNmixtureAD_BNB_oneObs(n, lambda, theta, prob, Nmin = -1, Nmax = -1)

dNmixtureAD_BBP_v(x, lambda, prob, s, Nmin = -1, Nmax = -1, len, log = 0)

dNmixtureAD_BBP_s(x, lambda, prob, s, Nmin = -1, Nmax = -1, len, log = 0)

dNmixtureAD_BBP_oneObs(x, lambda, prob, s, Nmin = -1, Nmax = -1, log = 0)

dNmixtureAD_BBNB_v(
  x,
  lambda,
  theta,
  prob,
  s,
  Nmin = -1,
  Nmax = -1,
  len,
  log = 0
)

dNmixtureAD_BBNB_s(
  x,
  lambda,
  theta,
  prob,
  s,
  Nmin = -1,
  Nmax = -1,
  len,
  log = 0
)

dNmixtureAD_BBNB_oneObs(
  x,
  lambda,
  theta,
  prob,
  s,
  Nmin = -1,
  Nmax = -1,
  log = 0
)

rNmixtureAD_BNB_v(n, lambda, theta, prob, Nmin = -1, Nmax = -1, len)

rNmixtureAD_BNB_s(n, lambda, theta, prob, Nmin = -1, Nmax = -1, len)

rNmixtureAD_BNB_oneObs(n, lambda, theta, prob, Nmin = -1, Nmax = -1)

rNmixtureAD_BBP_v(n, lambda, prob, s, Nmin = -1, Nmax = -1, len)

rNmixtureAD_BBP_s(n, lambda, prob, s, Nmin = -1, Nmax = -1, len)

rNmixtureAD_BBP_oneObs(n, lambda, prob, s, Nmin = -1, Nmax = -1)

rNmixtureAD_BBNB_v(n, lambda, theta, prob, s, Nmin = -1, Nmax = -1, len)

rNmixtureAD_BBNB_s(n, lambda, theta, prob, s, Nmin = -1, Nmax = -1, len)

rNmixtureAD_BBNB_oneObs(n, lambda, theta, prob, s, Nmin = -1, Nmax = -1)
}
\arguments{
\item{x}{vector of integer counts from a series of sampling occasions.}

\item{lambda}{expected value of the Poisson distribution of true abundance}

\item{prob}{detection probability (scalar for \code{dNmixture_s}, vector for \code{dNmixture_v}).}

\item{Nmin}{minimum abundance to sum over for the mixture probability. Must be provided.}

\item{Nmax}{maximum abundance to sum over for the mixture probability. Must be provided.}

\item{len}{The length of the x vector}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return probability.}

\item{n}{number of random draws, each returning a vector of length
\code{len}. Currently only \code{n = 1} is supported, but the
argument exists for standardization of "\code{r}" functions.}

\item{theta}{abundance overdispersion parameter required for negative binomial
(*NB) N-mixture models. theta is parameterized such that variance of
the negative binomial variable x is \code{lambda^2 * theta + lambda}}

\item{s}{detection overdispersion parameter required for beta binomial (BB*)
N-mixture models. s is parameterized such that variance of the beta
binomial variable x is \code{V(x) = N \* prob \* (1-prob) \* (N +
s) / (s + 1)}}
}
\value{
The probability (or likelihood) or log probability of an observation
  vector \code{x}.
}
\description{
\code{dNmixtureAD_s} and \code{dNmixtureAD_v} provide Poisson-Binomial
mixture distributions of abundance ("N-mixture") for use in \code{nimble}
models when automatic differentiation may be needed by an algorithm.
Overdispersion alternatives are also provided.
}
\details{
These nimbleFunctions provide distributions that can be
    used directly in R or in \code{nimble} hierarchical models (via
    \code{\link[nimble]{nimbleCode}} and
    \code{\link[nimble]{nimbleModel}}).

See \code{\link{dNmixture}} for more information about the N-mixture
distributions.

The versions here can be used in models that will be used by algorithms that
use nimble's system for automatic differentiation (AD). The primary
difference is that \code{Nmin} and \code{Nmax} must be provided. There are no
automatic defaults for these.

In the AD system some kinds of values are "baked in" (cannot be changed) to
the AD calculations from the first call, unless and until the AD calculations
are reset. For all variants of the \code{dNmixtureAD} distributions, the
sizes of the inputs as well as \code{Nmin} and \code{Nmax} are baked in.
These can be different for different iterations through a for loop (or nimble
model declarations with different indices, for example), but the sizes and
\code{Nmin} and \code{Nmax} values for each specific iteration will be
"baked in" after the first call.
}
\author{
Ben Goldstein, Lauren Ponisio, and Perry de Valpine
}
