% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_rec.R
\name{smooth_rec}
\alias{smooth_rec}
\title{Smooth character table values resulted from ancestral character state reconstructions}
\usage{
smooth_rec(whole_rec_table)
}
\arguments{
\item{whole_rec_table}{matrix containing all reconstructed characters for all
tips and nodes. It results from using the functions \code{\link{bin_par_rec}}
or \code{\link{bin_ml_rec}}.}
}
\value{
The matrix of reconstructed characters with smoothed values.
}
\description{
Smooth character table values resulted from ancestral character state reconstructions
}
\examples{
# a simple tree
data("tree5", package = "nichevol")

# simple matrix of data
dataTable <- cbind("241" = rep("1", length(tree5$tip.label)),
                   "242" = rep("1", length(tree5$tip.label)),
                   "243" = c("1", "1", "0", "0", "0"),
                   "244" = c("1", "1", "0", "0", "0"),
                   "245" = c("1", "?", "0", "0", "0"))
rownames(dataTable) <- tree5$tip.label
treeWdata <- geiger::treedata(tree5, dataTable)

# ancestral reconstruction
parsimonyReconstruction <- bin_par_rec(treeWdata)

# smoothing reconstructions
smooth_rec(parsimonyReconstruction)
}
