% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngbforcv.R
\name{NGBforecastCV}
\alias{NGBforecastCV}
\title{NGBoost forecasting model selection class}
\description{
It is a wrapper for the sklearn GridSearchCV with TimeSeriesSplit.
}
\examples{
\dontrun{

library(ngboostForecast)

dists <- list(Dist("Normal"))

base_learners <- list(sklearner(module = "tree", class = "DecisionTreeRegressor",
                                max_depth = 1),
                      sklearner(module = "tree", class = "DecisionTreeRegressor",
                                max_depth = 2),
                      sklearner(module = "tree", class = "DecisionTreeRegressor",
                                max_depth = 3),
                      sklearner(module = "tree", class = "DecisionTreeRegressor",
                                max_depth = 4),
                      sklearner(module = "tree", class = "DecisionTreeRegressor",
                                max_depth = 5),
                      sklearner(module = "tree", class = "DecisionTreeRegressor",
                                max_depth = 6),
                      sklearner(module = "tree", class = "DecisionTreeRegressor",
                                max_depth = 7))

scores <-  list(Scores("LogScore"))

model <- NGBforecastCV$new(Dist = dists,
                           Base = base_learners,
                           Score = scores,
                           natural_gradient = TRUE,
                           n_estimators = list(10, 100),
                           learning_rate = list(0.1, 0.2),
                           minibatch_frac = list(0.1, 1),
                           col_sample = list(0.3),
                           verbose = FALSE,
                           verbose_eval = 100,
                           tol = 1e-5)

params <- model$tune(y = AirPassengers,
seasonal = TRUE,
max_lag = 12,
xreg = NULL,
early_stopping_rounds = NULL,
n_splits = 4L)

params

}
}
\references{
\url{https://stanfordmlgroup.github.io/ngboost/2-tuning.html}
}
\author{
Resul Akay
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NGBforecastCV-new}{\code{NGBforecastCV$new()}}
\item \href{#method-NGBforecastCV-tune}{\code{NGBforecastCV$tune()}}
\item \href{#method-NGBforecastCV-clone}{\code{NGBforecastCV$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecastCV-new"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecastCV-new}{}}}
\subsection{Method \code{new()}}{
Initialize an NGBforecastCV model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecastCV$new(
  Dist = NULL,
  Score = NULL,
  Base = NULL,
  natural_gradient = TRUE,
  n_estimators = as.integer(500),
  learning_rate = 0.01,
  minibatch_frac = 1,
  col_sample = 1,
  verbose = TRUE,
  verbose_eval = as.integer(100),
  tol = 1e-04,
  random_state = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Dist}}{Assumed distributional form of \code{Y|X=x}. An output of
\code{\link{Dist}} function, e.g. \code{Dist('Normal')}}

\item{\code{Score}}{Rule to compare probabilistic predictions to
the observed data. A score from \code{\link{Scores}} function, e.g.
\code{Scores(score = "LogScore")}.}

\item{\code{Base}}{Base learner. An output of \code{\link{sklearner}} function,
e.g. \code{sklearner(module = "tree", class = "DecisionTreeRegressor", ...)}}

\item{\code{natural_gradient}}{Logical flag indicating whether the natural
gradient should be used}

\item{\code{n_estimators}}{The number of boosting iterations to fit}

\item{\code{learning_rate}}{The learning rate}

\item{\code{minibatch_frac}}{The percent subsample of rows to use in each
boosting iteration}

\item{\code{col_sample}}{The percent subsample of columns to use in each
boosting iteration}

\item{\code{verbose}}{Flag indicating whether output should be printed
during fitting. If TRUE it will print logs.}

\item{\code{verbose_eval}}{Increment (in boosting iterations) at which
output should be printed}

\item{\code{tol}}{Numerical tolerance to be used in optimization}

\item{\code{random_state}}{Seed for reproducibility.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An NGBforecastCV object that can be fit.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecastCV-tune"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecastCV-tune}{}}}
\subsection{Method \code{tune()}}{
Tune ngboosForecast.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecastCV$tune(
  y,
  max_lag = 5,
  xreg = NULL,
  seasonal = TRUE,
  K = frequency(y)/2 - 1,
  n_splits = NULL,
  train_loss_monitor = NULL,
  val_loss_monitor = NULL,
  early_stopping_rounds = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{A time series (ts) object}

\item{\code{max_lag}}{Maximum number of lags}

\item{\code{xreg}}{Optional. A numerical matrix of external regressors,
which must have the same number of rows as y.}

\item{\code{seasonal}}{Boolean. If \code{seasonal = TRUE} the fourier terms
will be used for modeling seasonality.}

\item{\code{K}}{Maximum order(s) of Fourier terms, used only if
\code{seasonal = TRUE}.}

\item{\code{n_splits}}{Number of splits. Must be at least 2.}

\item{\code{train_loss_monitor}}{A custom score or set of scores to track on the
training set during training. Defaults to the score defined in the NGBoost
constructor. Please do not modify unless you know what you are doing.}

\item{\code{val_loss_monitor}}{A custom score or set of scores to track on the
validation set during training. Defaults to the score defined in the
NGBoost  constructor. Please do not modify unless you know what you are
doing.}

\item{\code{early_stopping_rounds}}{The number of consecutive boosting
iterations during which the loss has to increase before the algorithm
stops early.}

\item{\code{test_size}}{The length of validation set.
If it is NULL, then, it is automatically specified.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A named list of best parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NGBforecastCV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NGBforecastCV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NGBforecastCV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
