% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transform_inverse.R
\docType{methods}
\name{transform_inverse}
\alias{transform_inverse}
\alias{transform_inverse-method}
\alias{transform_inverse,CLR,missing-method}
\alias{transform_inverse,GroupedCLR,missing-method}
\alias{transform_inverse,ALR,missing-method}
\alias{transform_inverse,GroupedALR,missing-method}
\alias{transform_inverse,ILR,missing-method}
\alias{transform_inverse,GroupedILR,missing-method}
\alias{transform_inverse,matrix,ILR-method}
\title{Inverse Log-Ratio Transformation}
\usage{
transform_inverse(object, origin, ...)

\S4method{transform_inverse}{CLR,missing}(object)

\S4method{transform_inverse}{GroupedCLR,missing}(object)

\S4method{transform_inverse}{ALR,missing}(object)

\S4method{transform_inverse}{GroupedALR,missing}(object)

\S4method{transform_inverse}{ILR,missing}(object)

\S4method{transform_inverse}{GroupedILR,missing}(object)

\S4method{transform_inverse}{matrix,ILR}(object, origin)
}
\arguments{
\item{object}{A \code{\linkS4class{LogRatio}} object.}

\item{origin}{A \code{\linkS4class{LogRatio}} object to be used for the inverse
transformation.}

\item{...}{Currently not used.}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object.
}
\description{
Computes inverse log-ratio transformations.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Centered log-ratio
clr <- transform_clr(coda)

## Inverse transformation
inv_clr <- transform_inverse(clr)
all.equal(coda, inv_clr)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall.

Egozcue, J. J., Pawlowsky-Glahn, V., Mateu-Figueras, G. & Barceló-Vidal, C.
(2003). Isometric Logratio Transformations for Compositional Data Analysis.
\emph{Mathematical Geology}, 35(3), 279-300. \doi{10.1023/A:1023818214614}.

Fišerová, E. & Hron, K. (2011). On the Interpretation of Orthonormal
Coordinates for Compositional Data. \emph{Mathematical Geosciences}, 43(4),
455‑468. \doi{10.1007/s11004-011-9333-x}.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.
}
\seealso{
Other log-ratio transformations: 
\code{\link{transform_alr}()},
\code{\link{transform_clr}()},
\code{\link{transform_ilr}()},
\code{\link{transform_lr}()},
\code{\link{transform_plr}()}
}
\author{
N. Frerebeau
}
\concept{log-ratio transformations}
