% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/simplex.R
\docType{methods}
\name{powering}
\alias{powering}
\alias{powering-method}
\alias{powering,numeric,numeric-method}
\alias{powering,CompositionMatrix,numeric-method}
\title{Powering Operation}
\usage{
powering(x, a, ...)

\S4method{powering}{numeric,numeric}(x, a)

\S4method{powering}{CompositionMatrix,numeric}(x, a)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of compositional data or a
\code{\linkS4class{CompositionMatrix}} object.}

\item{a}{A \code{\link{numeric}} constant.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Perturbation of two compositions.
}
\details{
In compositional geometry, powering replaces the product of a vector by a
scalar (scaling) and is defined as the closed powering of the components by
a given scalar.
}
\examples{
x <- as_composition(c(1, 2, 3))
y <- as_composition(c(1, 2, 1))

## Perturbation
perturbation(x, y)
x + y

## Powering
powering(y, 2)
y * 2

## Scalar product
scalar(x, y)
}
\seealso{
Other operations in the simplex: 
\code{\link{arithmetic}},
\code{\link{closure}()},
\code{\link{perturbation}()},
\code{\link{scalar}()}
}
\author{
N. Frerebeau
}
\concept{operations in the simplex}
