% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/mutators.R
\docType{class}
\name{LogRatio-class}
\alias{LogRatio-class}
\alias{.LogRatio}
\alias{LR-class}
\alias{.LR}
\alias{CLR-class}
\alias{.CLR}
\alias{ALR-class}
\alias{.ALR}
\alias{ILR-class}
\alias{.ILR}
\alias{PLR-class}
\alias{.PLR}
\alias{is_logratio}
\title{Log-Ratio Matrix}
\usage{
is_logratio(object)
}
\arguments{
\item{object}{A \code{LogRatio} object.}
}
\description{
S4 classes to represent log-ratio data transformations.
}
\section{Slots}{

\describe{
\item{\code{totals}}{A \code{\link{numeric}} vector to store the absolute row sums (before
the closure of the compositions).}

\item{\code{parts}}{A \code{\link{character}} vector to store the original part names.}

\item{\code{ratio}}{A \code{\link{character}} vector to store the ratio names.}

\item{\code{order}}{An \code{\link{integer}} vector to store the original ordering of the
columns.}

\item{\code{base}}{A \code{\link{numeric}} matrix to store the basis of the transformation.}

\item{\code{weights}}{A \code{\link{numeric}} vector to store the weights assigned to the
respective log-ratios.}
}}

\note{
These classes inherit from \code{\link{matrix}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is a \code{LogRatio} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
\code{\link[=transform_lr]{transform_lr()}}, \code{\link[=transform_clr]{transform_clr()}}, \code{\link[=transform_alr]{transform_alr()}},
\code{\link[=transform_ilr]{transform_ilr()}}, \code{\link[=transform_plr]{transform_plr()}}

Other classes: 
\code{\link{CompositionMatrix-class}},
\code{\link{GroupedComposition-class}},
\code{\link{GroupedLogRatio-class}},
\code{\link{NumericMatrix-class}},
\code{\link{OutlierIndex-class}},
\code{\link{ReferenceGroups-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
