% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgraphs.R
\name{subgraphs}
\alias{subgraphs}
\alias{subgraph_full}
\alias{subgraph_intra}
\alias{subgraph_inter}
\title{Full, intra and inter subgraph generators}
\usage{
subgraph_full(g, vids)

subgraph_intra(g, vids)

subgraph_inter(g, vids)
}
\arguments{
\item{g}{An \code{\link[igraph]{igraph}} object.}

\item{vids}{A list of integer vectors identifying vertex subsets.}
}
\value{
An \code{\link[igraph]{igraph}} object storing a subgraph of type
full, intra or inter.
}
\description{
This is a collection of functions for extracting full, intra and inter
subgraphs of a graph given a list of vertex subsets.
}
\examples{
g <- igraph::make_ring(10)
g_full  <- subgraph_full (g, list(1:3, 4:5, 8:10))
g_intra <- subgraph_intra(g, list(1:3, 4:5, 8:10))
g_inter <- subgraph_inter(g, list(1:3, 4:5, 8:10))

}
