% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{dist_nvd}
\alias{dist_nvd}
\title{Pairwise Distance Matrix Between Two Samples of Networks}
\usage{
dist_nvd(
  x,
  y = NULL,
  representation = "adjacency",
  distance = "frobenius",
  matching_iterations = 0,
  target_matrix = NULL
)
}
\arguments{
\item{x}{A \code{\link[base:list]{base::list}} of \code{\link[igraph:aaa-igraph-package]{igraph::igraph}} objects or matrix
representations of underlying networks from a given first population.}

\item{y}{A \code{\link[base:list]{base::list}} of \code{\link[igraph:aaa-igraph-package]{igraph::igraph}} objects or matrix
representations of underlying networks from a given second population.}

\item{representation}{A string specifying the desired type of representation,
among: \code{"adjacency"}, \code{"laplacian"}, \code{"modularity"} or
\code{"graphon"}. Default is \code{"laplacian"}.}

\item{distance}{A string specifying the chosen distance for calculating the
test statistic, among: \code{"hamming"}, \code{"frobenius"},
\code{"spectral"} and \code{"root-euclidean"}. Default is
\code{"frobenius"}.}

\item{matching_iterations}{An integer value specifying the maximum number of
runs when looking for the optimal permutation for graph matching. Defaults
to \code{0L} in which case no matching is done.}

\item{target_matrix}{A square numeric matrix of size \code{n} equal to the order
of the graphs specifying a target matrix towards which the initial doubly
stochastic matrix is shrunk each time the graph matching algorithm fails to
provide a good minimum. Defaults to \code{NULL} in which case the target matrix
is automatically chosen between the identity matrix or the uniform matrix
on the n-simplex.}
}
\value{
A matrix of dimension \eqn{(n_1+n_2) \times (n_1+n_2)} containing the
distances between all the elements of the two samples put together.
}
\description{
This function computes the matrix of pairwise distances between all the
elements of the two samples put together. The cardinality of the fist sample
is denoted by \eqn{n_1} and that of the second one is denoted by \eqn{n_2}.
}
\examples{
gnp_params <- list(p = 1/3)
k_regular_params <- list(k = 8L)
x <- nvd(model = "gnp", n = 10L, model_params = gnp_params)
y <- nvd(model = "k_regular", n = 10L, model_params = k_regular_params)
dist_nvd(x, y, "adjacency", "spectral")
}
