% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrainVolume.R
\name{makeVolume}
\alias{makeVolume}
\title{makeVolume}
\usage{
makeVolume(data = NULL, refvol, source = NULL, label = "",
  indices = NULL)
}
\arguments{
\item{data}{an optional one- or three-dimensional \code{vector} or \code{array}}

\item{refvol}{an instance of class \code{\linkS4class{BrainVolume}} containing the reference space for the new volume.}

\item{source}{an optional instance of class \code{\linkS4class{BrainSource}}}

\item{label}{an optional \code{character} string}

\item{indices}{an optional 1d vector of indices in to the 3d space}
}
\value{
\code{\linkS4class{DenseBrainVolume}} instance
}
\description{
Construct a \code{\linkS4class{BrainVolume}} instance, using default (dense) implementation
}
\examples{
bspace <- BrainSpace(c(64,64,64), spacing=c(1,1,1))
dat <- array(rnorm(64*64*64), c(64,64,64))
bvol <- BrainVolume(dat,bspace, label="test")
bvol2 <- makeVolume(dat, bvol)
all.equal(as.array(bvol),as.array(bvol2))
data <- 1:10
indices = seq(1,1000, length.out=10)
bvol3 <- makeVolume(data,bvol,indices=indices)
sum(bvol3) == sum(data)
}

