% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainSurface.R, R/SparseBrainVector.R, R/BrainVector.R, R/BrainVolume.R
\docType{methods}
\name{loadData}
\alias{loadData}
\alias{loadData,BrainBucketSource-method}
\alias{loadData,BrainSurfaceSource-method}
\alias{loadData,BrainVectorSource-method}
\alias{loadData,BrainVolumeSource-method}
\alias{loadData,SparseBrainVectorSource-method}
\title{Generic function to load data from a data source}
\usage{
loadData(x, ...)

\S4method{loadData}{BrainSurfaceSource}(x)

\S4method{loadData}{SparseBrainVectorSource}(x)

\S4method{loadData}{BrainVectorSource}(x, mmap = FALSE)

\S4method{loadData}{BrainBucketSource}(x, key)

\S4method{loadData}{BrainVolumeSource}(x)
}
\arguments{
\item{x}{a data source}

\item{...}{additional arguments}

\item{mmap}{use memory-mapped file}

\item{key}{the name or index of the bucket to load}
}
\value{
an instance of class \code{\linkS4class{BrainVector}}

an instance of class \code{\linkS4class{BrainVolume}}
}
\description{
Generic function to load data from a data source

load a BrainSurface

loadData

Load data from a \code{\linkS4class{BrainBucketSource}}

load a BrainVolume
}

