% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/file_format.R
\name{strip_extension}
\alias{strip_extension}
\alias{strip_extension,FileFormat,character-method}
\title{Generic function to strip extension from file name, given a \code{\linkS4class{FileFormat}} instance.}
\usage{
strip_extension(x, file_name)

\S4method{strip_extension}{FileFormat,character}(x, file_name)
}
\arguments{
\item{x}{A \linkS4class{FileFormat} object specifying the format requirements}

\item{file_name}{A character string specifying the file name to strip the
extension from}
}
\value{
A \code{character} string \code{file_name} without its extension.

A character string representing the file name without the extension
}
\description{
Removes the file extension from a given file name based on the FileFormat
specifications.
}
\details{
The function performs the following steps:
\enumerate{
  \item If the file_name matches the header file format, it removes the header
    extension.
  \item If the file_name matches the data file format, it removes the data
    extension.
  \item If the file_name doesn't match either format, it throws an error.
}
}
\examples{
# Create a FileFormat for NIFTI files
fmt <- new("FileFormat",
           header_extension = "nii",
           data_extension = "nii")

# Strip extension from a NIFTI file
strip_extension(fmt, "brain_scan.nii")  # Returns "brain_scan"

}
\seealso{
\code{\link{header_file}}, \code{\link{data_file}} for related file name
manipulation
}
