% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurovol.R
\name{split_fill}
\alias{split_fill}
\alias{split_fill,NeuroVol,factor,function-method}
\title{Fill Disjoint Sets of Values with the Output of a Function}
\usage{
split_fill(x, fac, FUN)

\S4method{split_fill}{NeuroVol,factor,function}(x, fac, FUN)
}
\arguments{
\item{x}{The object to split.}

\item{fac}{The \code{factor} to split by.}

\item{FUN}{The function used to summarize the sets.}
}
\value{
An object of the same class as \code{x}, with values replaced by the output of \code{FUN}.
}
\description{
This function splits an object into disjoint sets of values based on a factor, applies a specified function to each set,
and returns a new object with the original values replaced by the function's output.
}
\details{
The \code{FUN} function can either return a scalar for each input vector or a vector equal to the length of the input vector.
If it returns a scalar, every voxel in the set will be filled with that value in the output vector.
}
\examples{
## Summarize with mean -- FUN returns a scalar
x <- NeuroSpace(c(10, 10, 10), c(1, 1, 1))
vol <- NeuroVol(rnorm(10 * 10 * 10), x)
fac <- factor(rep(1:10, length.out=1000))
ovol.mean <- split_fill(vol, fac, mean)
identical(dim(ovol.mean), dim(vol))
length(unique(as.vector(ovol.mean))) == 10

## Transform by reversing vector -- FUN returns a vector
ovol2 <- split_fill(vol, fac, rev)

}
