% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neuro_obj.R, R/neurospace.R
\name{spacing}
\alias{spacing}
\alias{spacing,ROICoords-method}
\alias{spacing,NeuroObj-method}
\alias{spacing,NeuroSpace-method}
\title{Extract Voxel Dimensions of an Image}
\usage{
spacing(x)

\S4method{spacing}{ROICoords}(x)

\S4method{spacing}{NeuroObj}(x)

\S4method{spacing}{NeuroSpace}(x)
}
\arguments{
\item{x}{The object representing the image.}
}
\value{
A numeric vector specifying the voxel dimensions of \code{x}.
}
\description{
This function extracts the voxel dimensions of an image represented by the input object.
}
\examples{
bspace <- NeuroSpace(c(10, 10, 10), c(2, 2, 2))
all.equal(spacing(bspace), c(2, 2, 2))

}
