% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchlight.R
\name{searchlight}
\alias{searchlight}
\title{Create an exhaustive searchlight iterator}
\usage{
searchlight(mask, radius, eager = FALSE, nonzero = FALSE, cores = 0)
}
\arguments{
\item{mask}{A \code{\linkS4class{NeuroVol}} object representing the brain mask.}

\item{radius}{A numeric value specifying the radius (in mm) of the spherical searchlight.}

\item{eager}{A logical value specifying whether to eagerly compute the
searchlight ROIs. Default is FALSE, which uses lazy evaluation.}

\item{nonzero}{A logical value indicating whether to include only coordinates
with nonzero values in the supplied mask. Default is FALSE.}

\item{cores}{An integer specifying the number of cores to use for parallel
computation. Default is 0, which uses a single core.}
}
\value{
A \code{deferred_list} object containing either matrices of integer-valued
  voxel coordinates or \code{\linkS4class{ROIVolWindow}} objects, each representing
  a searchlight region.
}
\description{
This function generates an exhaustive searchlight iterator that returns either
voxel coordinates or ROIVolWindow objects for each searchlight sphere within
the provided mask. The iterator visits every non-zero voxel in the mask as a
potential center voxel.
}
\examples{
# Load an example brain mask
mask <- read_vol(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))

# Generate an exhaustive searchlight iterator with a radius of 6 mm

searchlights <- searchlight(mask, radius = 6, eager = FALSE)


}
