% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/common.R
\name{scale_series}
\alias{scale_series}
\alias{scale_series,NeuroVec,logical,missing-method}
\alias{scale_series,NeuroVec,logical,logical-method}
\alias{scale_series,NeuroVec,missing,logical-method}
\alias{scale_series,NeuroVec,missing,missing-method}
\title{Generic functions to scale (center and/or normalize by standard deviation) each series of a 4D image
That is, if the 4th dimension is 'time' each series is a 1D time series.}
\usage{
scale_series(x, center, scale)

\S4method{scale_series}{NeuroVec,logical,missing}(x, center, scale)

\S4method{scale_series}{NeuroVec,logical,logical}(x, center, scale)

\S4method{scale_series}{NeuroVec,missing,logical}(x, center, scale)

\S4method{scale_series}{NeuroVec,missing,missing}(x, center, scale)
}
\arguments{
\item{x}{a four dimensional image}

\item{center}{a \code{logical} value indicating whether series should be centered}

\item{scale}{a \code{logical} value indicating whether series should be divided by standard deviation}
}
\value{
An object of the same class as \code{x}, with each time series centered and/or scaled.
}
\description{
Generic functions to scale (center and/or normalize by standard deviation) each series of a 4D image
That is, if the 4th dimension is 'time' each series is a 1D time series.
}
\examples{
bvec <- NeuroVec(array(rnorm(24*24*24*24), c(24,24,24,24)), NeuroSpace(c(24,24,24,24), c(1,1,1)))
res <- scale_series(bvec, TRUE, TRUE)
}
