% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{indices}
\alias{indices}
\title{Extract indices}
\usage{
indices(x)
}
\arguments{
\item{x}{the object to extract indices}
}
\value{
A \code{vector} of indices from \code{x}.
}
\description{
Extract indices
}
\examples{
# Create a NeuroSpace object with 3mm voxels
space <- NeuroSpace(c(10,10,10), spacing=c(3,3,3))

# Create ROI coordinates in voxel space
coords <- matrix(c(1,1,1, 2,2,2), ncol=3, byrow=TRUE)

# Create ROI volume
roi_vol <- ROIVol(space, coords, data=c(1,2))

# Get linear indices of ROI voxels
idx <- indices(roi_vol)
# These indices can be used to index into a 3D array of size 10x10x10
}
