% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurospace.R
\name{index_to_coord}
\alias{index_to_coord}
\alias{index_to_coord,NeuroSpace,numeric-method}
\alias{index_to_coord,NeuroSpace,integer-method}
\alias{index_to_coord,NeuroVol,integer-method}
\alias{index_to_coord,NeuroVec,integer-method}
\title{convert 1d indices to n-dimensional real world coordinates}
\usage{
index_to_coord(x, idx)

\S4method{index_to_coord}{NeuroSpace,numeric}(x, idx)

\S4method{index_to_coord}{NeuroSpace,integer}(x, idx)

\S4method{index_to_coord}{NeuroVol,integer}(x, idx)

\S4method{index_to_coord}{NeuroVec,integer}(x, idx)
}
\arguments{
\item{x}{the object}

\item{idx}{the 1D indices}
}
\value{
A numeric \code{matrix} of real-world coordinates.
}
\description{
convert 1d indices to n-dimensional real world coordinates
}
\examples{
bvol <- NeuroVol(array(0, c(10,10,10)), NeuroSpace(c(10,10,10), c(1,1,1)))
idx <- 1:10
g <- index_to_coord(bvol, idx)
idx2 <- coord_to_index(bvol, g)
all.equal(idx, idx2)
}
