% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti_io.R
\name{createNIfTIHeader}
\alias{createNIfTIHeader}
\title{Create an Empty NIfTI-1 Header List}
\usage{
createNIfTIHeader(oneFile = TRUE, file_name = NULL)
}
\arguments{
\item{oneFile}{Logical; if \code{TRUE}, \code{magic} is set to \code{"n+1"}
indicating a single-file (.nii) approach. Otherwise set to \code{"ni1"}.}

\item{file_name}{Optional character string to store in the header, usually
referencing the intended output file name.}
}
\value{
A named \code{list} containing approximately 30 fields that comprise
  the NIfTI-1 header structure. Many of these are placeholders until filled by
  downstream usage.
}
\description{
Initializes a list of fields following the NIfTI-1 specification with default
or placeholder values. Users typically call this internally via
\code{\link{as_nifti_header}} rather than using directly.
}
\details{
This function sets up the skeleton of a NIfTI-1 header, including fields for
\code{diminfo}, \code{pixdim}, \code{qform_code}, \code{magic}, etc. Most fields
are initialized to zero, empty characters, or standard placeholders. The
\code{oneFile} argument controls whether \code{"n+1"} or \code{"ni1"} is used
for the \code{magic} field.
}
\seealso{
\code{\link{as_nifti_header}} for populating the returned header with actual
data from a \code{NeuroVol}.
}
