% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{Arith-methods}
\alias{Arith-methods}
\alias{Arith,SparseNeuroVol,SparseNeuroVol-method}
\alias{Arith,DenseNeuroVec,DenseNeuroVec-method}
\alias{Arith,SparseNeuroVol,NeuroVol-method}
\alias{Arith,NeuroVol,SparseNeuroVol-method}
\alias{Arith,DenseNeuroVol,DenseNeuroVol-method}
\alias{Arith,NeuroVec,NeuroVec-method}
\alias{Arith,SparseNeuroVec,SparseNeuroVec-method}
\title{Arithmetic Operations}
\usage{
\S4method{Arith}{SparseNeuroVol,SparseNeuroVol}(e1, e2)

\S4method{Arith}{DenseNeuroVol,DenseNeuroVol}(e1, e2)

\S4method{Arith}{DenseNeuroVec,DenseNeuroVec}(e1, e2)

\S4method{Arith}{SparseNeuroVol,NeuroVol}(e1, e2)

\S4method{Arith}{NeuroVol,SparseNeuroVol}(e1, e2)

\S4method{Arith}{NeuroVec,NeuroVec}(e1, e2)

\S4method{Arith}{NeuroVol,SparseNeuroVol}(e1, e2)

\S4method{Arith}{SparseNeuroVec,SparseNeuroVec}(e1, e2)
}
\arguments{
\item{e1}{A NeuroVol object.}

\item{e2}{A SparseNeuroVol object.}
}
\value{
A DenseNeuroVol object representing the result of the arithmetic operation.

An ROIVol object containing the result of the arithmetic operation between \code{e1} and \code{e2}.

A SparseNeuroVec object representing the result of the arithmetic operation.

A DenseNeuroVol object representing the result of the arithmetic operation.

A DenseNeuroVol object representing the result of the arithmetic operation.

A DenseNeuroVec object representing the result of the arithmetic operation.

A DenseNeuroVol object representing the result of the arithmetic operation.
}
\description{
Methods for performing arithmetic operations on neuroimaging objects

This method performs arithmetic operations between two ROIVol objects (\code{e1} and \code{e2}) using a generic arithmetic function.
The dimensions of both objects are checked for compatibility before performing the operation.

Perform an arithmetic operation between two SparseNeuroVec objects.
The input SparseNeuroVec objects must have the same dimensions and NeuroSpace objects.
The method computes the union of the masks and performs the arithmetic operation
on the non-zero values. The result is returned as a new SparseNeuroVec object.

Perform an arithmetic operation between a SparseNeuroVol object and a NeuroVol object.
The input SparseNeuroVol and NeuroVol objects must have the same dimensions.
The method performs the arithmetic operation on the non-zero values of the SparseNeuroVol
and the corresponding values of the NeuroVol. The result is returned as a new DenseNeuroVol object.

Perform an arithmetic operation between a NeuroVol object and a SparseNeuroVol object.
The input NeuroVol and SparseNeuroVol objects must have the same dimensions.
The method performs the arithmetic operation on the values of the NeuroVol and the non-zero values
of the SparseNeuroVol. The result is returned as a new DenseNeuroVol object.

Perform an arithmetic operation between two NeuroVec objects.
The input NeuroVec objects must have the same dimensions.
The method performs the arithmetic operation on the elements of the NeuroVec objects.
The result is returned as a new DenseNeuroVec object.

Perform an arithmetic operation between a NeuroVol object and a SparseNeuroVol object.
The input NeuroVol and SparseNeuroVol objects must have the same dimensions.
The method performs the arithmetic operation on the values of the NeuroVol and the non-zero values
of the SparseNeuroVol. The result is returned as a new DenseNeuroVol object.
}
