% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_hcp_dir.R
\name{download_hcp_dir}
\alias{download_hcp_dir}
\alias{download_fcp_dir}
\alias{download_openneuro_dir}
\title{Download an entire directory from HCP}
\usage{
download_hcp_dir(
  prefix,
  delimiter = "",
  outdir = tempfile(),
  verbose = TRUE,
  ...
)

download_fcp_dir(...)

download_openneuro_dir(...)
}
\arguments{
\item{prefix}{Folder to download}

\item{delimiter}{Delimiter for files}

\item{outdir}{Output directory}

\item{verbose}{Should diagnostic values be printed?}

\item{...}{additional arguments to pass to \code{\link{hcp_list_files}}}
}
\value{
List of return from calling \code{\link{hcp_list_files}},
the output directory, and all destination files (not subsetted by those
that did in fact download)
}
\description{
Downloads a directory/folder from HCP database
}
\examples{
if (have_aws_key()) {
   prefix = "HCP/100307/release-notes"
   res = download_hcp_dir(prefix = prefix, verbose = FALSE)
}
}
