% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanNormalization.R
\name{meanNormalization}
\alias{meanNormalization}
\title{Mean Normalization for Matrix Data}
\usage{
meanNormalization(
  matrixData,
  handleInvalidRows = c("warn", "error", "omit"),
  returnDetails = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{matrixData}{A \code{matrix} where each row represents one subject’s PET data,
typically generated by \code{\link{matrixCreator}}.}

\item{handleInvalidRows}{\code{character}. Specifies how to handle rows with invalid means (either zero or \code{NA}).
Options include \code{"warn"} (default), \code{"error"}, or \code{"omit"}.}

\item{returnDetails}{\code{logical}. If \code{TRUE}, returns a list with the normalized matrix and
additional diagnostics. If \code{FALSE} (default), returns only the normalized matrix.}

\item{quiet}{\code{logical}. If \code{TRUE}, suppresses console messages. Default is \code{FALSE}.}
}
\value{
A normalized matrix, or a list if \code{returnDetails = TRUE}.
\itemize{
  \item \code{normalizedMatrix} – The normalized matrix.
  \item \code{problemRows} – Indices of rows that had zero or \code{NA} means.
}
}
\description{
Normalizes each row of a matrix by dividing its elements by the row mean, ignoring \code{NA} values.
This step is commonly used to adjust for global intensity differences across subjects before
applying statistical comparisons or functional data analysis.
}
\details{
The function performs the following steps
\enumerate{
  \item Computes the row means of the input matrix, ignoring \code{NA}s.
  \item Divides each row by its corresponding mean.
  \item Replaces \code{NaN} values (from division by 0) with \code{0} if applicable.
  \item Handles problematic rows according to the selected \code{handleInvalidRows} option:
        \code{"warn"} (default) issues a warning, \code{"error"} stops execution,
        and \code{"omit"} removes the affected rows from the result.
}

This step is often used prior to applying SCC methods to ensure comparability across subjects.
}
\examples{
# Generate a minimal database and create a matrix (1 control subject)
dataDir <- system.file("extdata", package = "neuroSCC")
controlPattern <- "^syntheticControl1\\\\.nii\\\\.gz$"
databaseControls <- databaseCreator(pattern = controlPattern,
                                    control = TRUE,
                                    quiet = TRUE)
matrixControls <- matrixCreator(databaseControls, paramZ = 35, quiet = TRUE)

# Normalize the matrix (with diagnostics)
normalizationResult <- meanNormalization(matrixControls,
                                         returnDetails = TRUE,
                                         quiet = FALSE)

}
\seealso{
\code{\link{matrixCreator}} for building the matrix input to normalize.
}
