% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netHTML_3_arrows.R
\name{netHTML3arrows}
\alias{netHTML3arrows}
\title{Generate Network Maze (3 arrows)}
\usage{
netHTML3arrows(nodeLogic = NULL, wd = NULL, names = NULL,
  concerto = "C5")
}
\arguments{
\item{nodeLogic}{This is the connections between the nodes.}

\item{wd}{is the working directory to save the HTML source code in. If not given, the file will be saved in the default working directory.}

\item{names}{This allows you to put in your own names in the nodes when generating the maze.}

\item{concerto}{Choose between concerto 4 or concerto 5. So if you are not using concerto, you might want to change the default option to concerto 4 instead.}
}
\description{
This function generates an network Maze with 3 arrows.
}
\details{
This function creates a maze and is saved into your working directory. This is regardless of whether it is a trail or circuit type maze. 3 arrows per maze is generated. Bearing in mind that with 3 arrows, the maze may not always be solved. Hence, it still requires checking prior to using it as a test.
}
\examples{
#create random names
countries <- c("Croatia","Cyprus","Denmark","Finland","France","Germany",
"Greece","Hungary","Iceland","UK","US")

#create node logic
logic <- nodeLogic(value = 8, type= "circuit", itemFamily= 1)

#Folder to save html/
#setwd("~/desktop")
#filePath<- getwd()

#Generate item
set.seed(1)
netHTML3arrows(logic, wd=NULL, names = countries,concerto="C5")


}
\author{
Aiden Loe
}
