% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_profiles.R
\name{snac_resample}
\alias{snac_resample}
\title{Resampled SNAC+}
\usage{
snac_resample(
  A,
  nrep = 20,
  Kmin = 1,
  Kmax = 13,
  ncores = parallel::detectCores() - 1,
  seed = 1234
)
}
\arguments{
\item{A}{adjacency matrix}

\item{nrep}{number of times SNAC+ is computed}

\item{Kmin}{minimum community number to use in SNAC+}

\item{Kmax}{maximum community number to use in SNAC+}

\item{ncores}{number of cores to use in the parallel computing}

\item{seed}{seed for random sampling}
}
\value{
A data frame with columns specifying repetition cycles,
number of community numbers and the value of SNAC+ statistics
}
\description{
Compute SNAC+ with resampling
}
